/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Resource;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.lang.SystemUtil;
import org.codelibs.fess.crawler.entity.AccessResult;
import org.codelibs.fess.crawler.entity.AccessResultImpl;
import org.codelibs.fess.crawler.entity.UrlQueue;
import org.codelibs.fess.crawler.entity.UrlQueueImpl;
import org.codelibs.fess.crawler.helper.MemoryDataHelper;
import org.codelibs.fess.crawler.service.UrlQueueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlQueueServiceImpl
implements UrlQueueService<UrlQueueImpl<Long>> {
    private static final Logger logger = LoggerFactory.getLogger(UrlQueueServiceImpl.class);
    @Resource
    protected MemoryDataHelper dataHelper;

    @Override
    public void updateSessionId(String oldSessionId, String newSessionId) {
        Queue<UrlQueueImpl<Long>> urlQueueList = this.dataHelper.getUrlQueueList(oldSessionId);
        this.dataHelper.addUrlQueueList(newSessionId, urlQueueList);
        this.dataHelper.removeUrlQueueList(oldSessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String sessionId, String url) {
        Queue<UrlQueueImpl<Long>> urlQueueList;
        Queue<UrlQueueImpl<Long>> queue = urlQueueList = this.dataHelper.getUrlQueueList(sessionId);
        synchronized (queue) {
            UrlQueueImpl urlQueue = new UrlQueueImpl();
            urlQueue.setSessionId(sessionId);
            urlQueue.setMethod("GET");
            urlQueue.setUrl(url);
            urlQueue.setUrl(url);
            urlQueue.setDepth(0);
            urlQueue.setCreateTime(SystemUtil.currentTimeMillis());
            urlQueueList.add(urlQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(UrlQueueImpl<Long> urlQueue) {
        Queue<UrlQueueImpl<Long>> urlQueueList;
        Queue<UrlQueueImpl<Long>> queue = urlQueueList = this.dataHelper.getUrlQueueList(urlQueue.getSessionId());
        synchronized (queue) {
            urlQueueList.add(urlQueue);
        }
    }

    @Override
    public void delete(String sessionId) {
        this.dataHelper.removeUrlQueueList(sessionId);
    }

    @Override
    public void deleteAll() {
        this.dataHelper.clearUrlQueueList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offerAll(String sessionId, List<UrlQueueImpl<Long>> newUrlQueueList) {
        Queue<UrlQueueImpl<Long>> urlQueueList;
        Queue<UrlQueueImpl<Long>> queue = urlQueueList = this.dataHelper.getUrlQueueList(sessionId);
        synchronized (queue) {
            ArrayList<UrlQueueImpl<Long>> targetList = new ArrayList<UrlQueueImpl<Long>>();
            for (UrlQueueImpl<Long> urlQueue : newUrlQueueList) {
                if (!this.isNewUrl(urlQueue, urlQueueList)) continue;
                targetList.add(urlQueue);
            }
            urlQueueList.addAll(targetList);
        }
    }

    protected boolean isNewUrl(UrlQueueImpl<Long> urlQueue, Queue<UrlQueueImpl<Long>> urlQueueList) {
        String url = urlQueue.getUrl();
        if (StringUtil.isBlank((String)url)) {
            if (logger.isDebugEnabled()) {
                logger.debug("URL is a blank: " + url);
            }
            return false;
        }
        for (UrlQueue urlQueue2 : urlQueueList) {
            if (!url.equals(urlQueue2.getUrl())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("URL exists in a queue: " + url);
            }
            return false;
        }
        AccessResult accessResult = this.dataHelper.getAccessResultMap(urlQueue.getSessionId()).get(url);
        if (accessResult != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("URL exists in a result: " + url);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UrlQueueImpl<Long> poll(String sessionId) {
        Queue<UrlQueueImpl<Long>> urlQueueList;
        Queue<UrlQueueImpl<Long>> queue = urlQueueList = this.dataHelper.getUrlQueueList(sessionId);
        synchronized (queue) {
            return urlQueueList.poll();
        }
    }

    @Override
    public void saveSession(String sessionId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visited(UrlQueueImpl<Long> urlQueue) {
        Queue<UrlQueueImpl<Long>> urlQueueList;
        Queue<UrlQueueImpl<Long>> queue = urlQueueList = this.dataHelper.getUrlQueueList(urlQueue.getSessionId());
        synchronized (queue) {
            return !this.isNewUrl(urlQueue, urlQueueList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateUrlQueues(String previousSessionId, String sessionId) {
        Queue<UrlQueueImpl<Long>> urlQueueList = this.dataHelper.getUrlQueueList(sessionId);
        Map<String, AccessResultImpl<Long>> arMap = this.dataHelper.getAccessResultMap(previousSessionId);
        for (Map.Entry<String, AccessResultImpl<Long>> entry : arMap.entrySet()) {
            Queue<UrlQueueImpl<Long>> queue = urlQueueList;
            synchronized (queue) {
                UrlQueueImpl urlQueue = new UrlQueueImpl();
                urlQueue.setSessionId(sessionId);
                urlQueue.setMethod(entry.getValue().getMethod());
                urlQueue.setUrl(entry.getValue().getUrl());
                urlQueue.setParentUrl(entry.getValue().getParentUrl());
                urlQueue.setDepth(0);
                urlQueue.setLastModified(entry.getValue().getLastModified());
                urlQueue.setCreateTime(SystemUtil.currentTimeMillis());
                urlQueueList.add(urlQueue);
            }
        }
    }
}

