/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.transformer.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.codelibs.fess.crawler.entity.AccessResultData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.entity.ResultData;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.transformer.impl.AbstractTransformer;

public class BinaryTransformer
extends AbstractTransformer {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultData transform(ResponseData responseData) {
        if (responseData == null) throw new CrawlingAccessException("No response body.");
        if (!responseData.hasResponseBody()) {
            throw new CrawlingAccessException("No response body.");
        }
        ResultData resultData = new ResultData();
        resultData.setTransformerName(this.getName());
        try (BufferedInputStream bis = new BufferedInputStream(responseData.getResponseBody());){
            resultData.setData(IOUtils.toByteArray((InputStream)bis));
            resultData.setEncoding(responseData.getCharSet());
            ResultData resultData2 = resultData;
            return resultData2;
        }
        catch (IOException e) {
            throw new CrawlerSystemException("Could not convert the input stream.", e);
        }
    }

    @Override
    public Object getData(AccessResultData<?> accessResultData) {
        if (!this.getName().equals(accessResultData.getTransformerName())) {
            throw new CrawlerSystemException("Transformer is invalid. Use " + accessResultData.getTransformerName() + ". This transformer is " + this.getName() + ".");
        }
        byte[] data = accessResultData.getData();
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data);
    }
}

