/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.transformer.impl;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import org.apache.xpath.objects.XObject;
import org.codelibs.core.beans.util.BeanUtil;
import org.codelibs.fess.crawler.Constants;
import org.codelibs.fess.crawler.entity.AccessResultData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.entity.ResultData;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.transformer.impl.HtmlTransformer;
import org.codelibs.fess.crawler.util.UnsafeStringBuilder;
import org.codelibs.fess.crawler.util.XmlUtil;
import org.cyberneko.html.parsers.DOMParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XpathTransformer
extends HtmlTransformer {
    private static final Logger logger = LoggerFactory.getLogger(XpathTransformer.class);
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+", 8);
    protected Map<String, String> fieldRuleMap = new LinkedHashMap<String, String>();
    protected boolean trimSpace = true;
    protected String charsetName = "UTF-8";
    protected Class<?> dataClass = null;

    @Override
    protected void storeData(ResponseData responseData, ResultData resultData) {
        DOMParser parser = this.getDomParser();
        try (InputStream in = responseData.getResponseBody();){
            InputSource is = new InputSource(in);
            if (responseData.getCharSet() != null) {
                is.setEncoding(responseData.getCharSet());
            }
            parser.parse(is);
        }
        catch (Exception e) {
            throw new CrawlingAccessException("Could not parse " + responseData.getUrl(), e);
        }
        Document document = parser.getDocument();
        UnsafeStringBuilder buf = new UnsafeStringBuilder(1000);
        buf.append(this.getResultDataHeader());
        for (Map.Entry entry : this.fieldRuleMap.entrySet()) {
            String path = (String)entry.getValue();
            try {
                XObject xObj = this.getXPathAPI().eval((Node)document, path);
                int type = xObj.getType();
                switch (type) {
                    case 1: {
                        boolean b = xObj.bool();
                        buf.append(this.getResultDataBody((String)entry.getKey(), Boolean.toString(b)));
                        break;
                    }
                    case 2: {
                        double d = xObj.num();
                        buf.append(this.getResultDataBody((String)entry.getKey(), Double.toString(d)));
                        break;
                    }
                    case 3: {
                        String str = xObj.str();
                        buf.append(this.getResultDataBody((String)entry.getKey(), str.trim()));
                        break;
                    }
                    case 4: {
                        NodeList nodeList = xObj.nodelist();
                        ArrayList<String> strList = new ArrayList<String>();
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            Node node = nodeList.item(i);
                            strList.add(node.getTextContent());
                        }
                        buf.append(this.getResultDataBody((String)entry.getKey(), strList));
                        break;
                    }
                    case 5: {
                        int rtf = xObj.rtf();
                        buf.append(this.getResultDataBody((String)entry.getKey(), Integer.toString(rtf)));
                        break;
                    }
                    default: {
                        Object obj = xObj.object();
                        if (obj == null) {
                            obj = "";
                        }
                        buf.append(this.getResultDataBody((String)entry.getKey(), obj.toString()));
                        break;
                    }
                }
            }
            catch (TransformerException e) {
                logger.warn("Could not parse a value of " + (String)entry.getKey() + ":" + (String)entry.getValue());
            }
        }
        buf.append(this.getAdditionalData(responseData, document));
        buf.append(this.getResultDataFooter());
        String data = buf.toUnsafeString().trim();
        try {
            resultData.setData(data.getBytes(this.charsetName));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (logger.isInfoEnabled()) {
                logger.info("Invalid charsetName: " + this.charsetName + ". Changed to " + "UTF-8", (Throwable)unsupportedEncodingException);
            }
            this.charsetName = Constants.UTF_8_CHARSET.name();
            resultData.setData(data.getBytes(Constants.UTF_8_CHARSET));
        }
        resultData.setEncoding(this.charsetName);
    }

    protected String getResultDataHeader() {
        return "<?xml version=\"1.0\"?>\n<doc>\n";
    }

    protected String getResultDataBody(String name, String value) {
        return "<field name=\"" + XmlUtil.escapeXml(name) + "\">" + this.trimSpace(XmlUtil.escapeXml(value != null ? value : "")) + "</field>\n";
    }

    protected String getResultDataBody(String name, List<String> values) {
        UnsafeStringBuilder buf = new UnsafeStringBuilder();
        buf.append("<list>");
        if (values != null && !values.isEmpty()) {
            for (String value : values) {
                buf.append("<item>");
                buf.append(this.trimSpace(XmlUtil.escapeXml(value)));
                buf.append("</item>");
            }
        }
        buf.append("</list>");
        return "<field name=\"" + XmlUtil.escapeXml(name) + "\">" + buf.toUnsafeString().trim() + "</field>\n";
    }

    protected String getAdditionalData(ResponseData responseData, Document document) {
        return "";
    }

    protected String getResultDataFooter() {
        return "</doc>";
    }

    protected String trimSpace(String value) {
        if (this.trimSpace) {
            Matcher matcher = SPACE_PATTERN.matcher(value);
            return matcher.replaceAll(" ").trim();
        }
        return value;
    }

    public void addFieldRule(String name, String xpath) {
        this.fieldRuleMap.put(name, xpath);
    }

    @Override
    public Object getData(AccessResultData<?> accessResultData) {
        if (this.dataClass == null) {
            return super.getData(accessResultData);
        }
        Map<String, Object> dataMap = XmlUtil.getDataMap(accessResultData);
        if (Map.class.equals(this.dataClass)) {
            return dataMap;
        }
        try {
            Object obj = this.dataClass.newInstance();
            BeanUtil.copyMapToBean(dataMap, obj);
            return obj;
        }
        catch (Exception e) {
            throw new CrawlerSystemException("Could not create/copy a data map to " + this.dataClass, e);
        }
    }

    public Map<String, String> getFieldRuleMap() {
        return this.fieldRuleMap;
    }

    public void setFieldRuleMap(Map<String, String> fieldRuleMap) {
        this.fieldRuleMap = fieldRuleMap;
    }

    public boolean isTrimSpace() {
        return this.trimSpace;
    }

    public void setTrimSpace(boolean trimSpace) {
        this.trimSpace = trimSpace;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public Class<?> getDataClass() {
        return this.dataClass;
    }

    public void setDataClass(Class<?> dataClass) {
        this.dataClass = dataClass;
    }
}

