/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.codelibs.core.io.CopyUtil;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResponseDataUtil {
    private static final Logger logger = LoggerFactory.getLogger(ResponseDataUtil.class);

    private ResponseDataUtil() {
    }

    public static File createResponseBodyFile(ResponseData responseData) {
        File tempFile = null;
        FileOutputStream fos = null;
        try (InputStream is = responseData.getResponseBody();){
            tempFile = File.createTempFile("crawler-", ".tmp");
            fos = new FileOutputStream(tempFile);
            CopyUtil.copy((InputStream)is, (OutputStream)fos);
        }
        catch (Exception e) {
            try {
                IOUtils.closeQuietly(fos);
                if (tempFile != null && !tempFile.delete()) {
                    logger.warn("Could not delete a temp file: " + tempFile);
                }
                throw new CrawlingAccessException("Could not read a response body: " + responseData.getUrl(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
        return tempFile;
    }
}

