/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.annotation.Resource;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.crawler.CrawlerContext;
import org.codelibs.fess.crawler.CrawlerStatus;
import org.codelibs.fess.crawler.CrawlerThread;
import org.codelibs.fess.crawler.client.CrawlerClientFactory;
import org.codelibs.fess.crawler.container.CrawlerContainer;
import org.codelibs.fess.crawler.entity.AccessResult;
import org.codelibs.fess.crawler.entity.UrlQueue;
import org.codelibs.fess.crawler.filter.UrlFilter;
import org.codelibs.fess.crawler.interval.IntervalController;
import org.codelibs.fess.crawler.rule.RuleManager;
import org.codelibs.fess.crawler.service.DataService;
import org.codelibs.fess.crawler.service.UrlQueueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crawler
implements Runnable,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Crawler.class);
    @Resource
    protected UrlQueueService<UrlQueue<?>> urlQueueService;
    @Resource
    protected DataService<AccessResult<?>> dataService;
    @Resource
    protected UrlFilter urlFilter;
    @Resource
    protected RuleManager ruleManager;
    @Resource
    protected CrawlerContainer crawlerContainer;
    @Resource
    protected IntervalController intervalController;
    @Resource
    protected CrawlerClientFactory clientFactory;
    protected CrawlerContext crawlerContext = new CrawlerContext();
    protected boolean background = false;
    protected boolean daemon = false;
    protected int threadPriority = 5;
    protected Thread parentThread;
    protected ThreadGroup crawlerThreadGroup;

    public Crawler() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ENGLISH);
        this.crawlerContext.sessionId = sdf.format(new Date());
    }

    public void addUrl(String url) {
        try {
            this.urlQueueService.add(this.crawlerContext.sessionId, url);
        }
        catch (Exception e) {
            logger.warn("Failed to add url: " + url, (Throwable)e);
        }
        this.urlFilter.processUrl(url);
    }

    public String getSessionId() {
        return this.crawlerContext.sessionId;
    }

    public void setSessionId(String sessionId) {
        if (StringUtil.isNotBlank((String)sessionId) && !sessionId.equals(this.crawlerContext.sessionId)) {
            this.urlQueueService.updateSessionId(this.crawlerContext.sessionId, sessionId);
            this.crawlerContext.sessionId = sessionId;
        }
    }

    public String execute() {
        this.parentThread = new Thread((Runnable)this, "Crawler-" + this.crawlerContext.sessionId);
        this.parentThread.setDaemon(this.daemon);
        this.parentThread.start();
        if (!this.background) {
            this.awaitTermination();
        }
        return this.crawlerContext.sessionId;
    }

    public void awaitTermination() {
        this.awaitTermination(0L);
    }

    public void awaitTermination(long millis) {
        if (this.parentThread != null) {
            try {
                this.parentThread.join(millis);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted job at {}", (Object)this.parentThread.getName());
            }
        }
    }

    public void cleanup(String sessionId) {
        this.urlQueueService.delete(sessionId);
        this.dataService.delete(sessionId);
        this.urlFilter.clear();
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    public void addIncludeFilter(String regexp) {
        if (StringUtil.isNotBlank((String)regexp)) {
            this.urlFilter.addInclude(regexp);
        }
    }

    public void addExcludeFilter(String regexp) {
        if (StringUtil.isNotBlank((String)regexp)) {
            this.urlFilter.addExclude(regexp);
        }
    }

    public void stop() {
        this.crawlerContext.setStatus(CrawlerStatus.DONE);
        try {
            if (this.crawlerThreadGroup != null) {
                this.crawlerThreadGroup.interrupt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public UrlFilter getUrlFilter() {
        return this.urlFilter;
    }

    public void setUrlFilter(UrlFilter urlFilter) {
        this.urlFilter = urlFilter;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public void setRuleManager(RuleManager ruleManager) {
        this.ruleManager = ruleManager;
    }

    public IntervalController getIntervalController() {
        return this.intervalController;
    }

    public void setIntervalController(IntervalController intervalController) {
        this.intervalController = intervalController;
    }

    public CrawlerClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public boolean isBackground() {
        return this.background;
    }

    public void setBackground(boolean background) {
        this.background = background;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    @Override
    public void run() {
        int i;
        this.crawlerContext.urlFilter = this.urlFilter;
        this.crawlerContext.ruleManager = this.ruleManager;
        this.crawlerContext.intervalController = this.intervalController;
        this.urlFilter.init(this.crawlerContext.sessionId);
        this.crawlerThreadGroup = new ThreadGroup("Crawler-" + this.crawlerContext.sessionId);
        Thread[] threads = new Thread[this.crawlerContext.getNumOfThread()];
        for (i = 0; i < this.crawlerContext.getNumOfThread(); ++i) {
            CrawlerThread crawlerThread = (CrawlerThread)this.crawlerContainer.getComponent("crawlerThread");
            crawlerThread.setCrawlerContext(this.crawlerContext);
            crawlerThread.setClientFactory(this.clientFactory);
            threads[i] = new Thread(this.crawlerThreadGroup, crawlerThread, "Crawler-" + this.crawlerContext.sessionId + "-" + Integer.toString(i + 1));
            threads[i].setDaemon(this.daemon);
            threads[i].setPriority(this.threadPriority);
        }
        this.crawlerContext.setStatus(CrawlerStatus.RUNNING);
        for (i = 0; i < this.crawlerContext.numOfThread; ++i) {
            threads[i].start();
        }
        for (i = 0; i < this.crawlerContext.numOfThread; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted job at {}", (Object)threads[i].getName());
            }
        }
        this.crawlerContext.setStatus(CrawlerStatus.DONE);
        this.urlQueueService.saveSession(this.crawlerContext.sessionId);
    }

    public CrawlerContext getCrawlerContext() {
        return this.crawlerContext;
    }

    public void setNumOfThread(int numOfThread) {
        this.crawlerContext.numOfThread = numOfThread;
    }

    public void setMaxThreadCheckCount(int maxThreadCheckCount) {
        this.crawlerContext.maxThreadCheckCount = maxThreadCheckCount;
    }

    public void setMaxDepth(int maxDepth) {
        this.crawlerContext.maxDepth = maxDepth;
    }

    public void setMaxAccessCount(long maxAccessCount) {
        this.crawlerContext.maxAccessCount = maxAccessCount;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }
}

