/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client.http;

import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.codelibs.core.timer.TimeoutTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HcConnectionMonitorTarget
implements TimeoutTarget {
    private static final Logger logger = LoggerFactory.getLogger(HcConnectionMonitorTarget.class);
    private final HttpClientConnectionManager clientConnectionManager;
    private final long idleConnectionTimeout;

    public HcConnectionMonitorTarget(HttpClientConnectionManager clientConnectionManager, long idleConnectionTimeout) {
        this.clientConnectionManager = clientConnectionManager;
        this.idleConnectionTimeout = idleConnectionTimeout;
    }

    public void expired() {
        if (this.clientConnectionManager == null) {
            logger.warn("clientConnectionManager is null.");
            return;
        }
        try {
            this.clientConnectionManager.closeExpiredConnections();
            this.clientConnectionManager.closeIdleConnections(this.idleConnectionTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.warn("A connection monitoring exception occurs.", (Throwable)e);
        }
    }
}

