/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.extractor;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.crawler.container.CrawlerContainer;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.extractor.Extractor;
import org.codelibs.fess.crawler.extractor.ExtractorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractorFactory {
    private static final Logger logger = LoggerFactory.getLogger(ExtractorFactory.class);
    @Resource
    protected CrawlerContainer crawlerContainer;
    protected Map<String, Extractor> extractorMap = new HashMap<String, Extractor>();

    public void addExtractor(String key, Extractor extractor) {
        if (StringUtil.isBlank((String)key)) {
            throw new CrawlerSystemException("The key is null.");
        }
        if (extractor == null) {
            throw new CrawlerSystemException("The extractor is null.");
        }
        this.extractorMap.put(key, extractor);
        if (logger.isDebugEnabled()) {
            logger.debug("Loaded {} : {}", (Object)key, (Object)extractor.getClass().getName());
        }
    }

    public void addExtractor(List<String> keyList, Extractor extractor) {
        if (keyList == null || keyList.isEmpty()) {
            throw new CrawlerSystemException("The key list is empty.");
        }
        for (String key : keyList) {
            this.addExtractor(key, extractor);
        }
    }

    public Extractor getExtractor(String key) {
        return this.extractorMap.get(key);
    }

    public void setExtractorMap(Map<String, Extractor> extractorMap) {
        this.extractorMap = extractorMap;
    }

    public ExtractorBuilder builder(InputStream in, Map<String, String> params) {
        return new ExtractorBuilder(this.crawlerContainer, in, params);
    }
}

