/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.extractor.impl;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.codelibs.core.beans.BeanDesc;
import org.codelibs.core.beans.PropertyDesc;
import org.codelibs.core.beans.factory.BeanDescFactory;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.timer.TimeoutManager;
import org.codelibs.core.timer.TimeoutTarget;
import org.codelibs.core.timer.TimeoutTask;
import org.codelibs.fess.crawler.client.AccessTimeoutTarget;
import org.codelibs.fess.crawler.client.http.Authentication;
import org.codelibs.fess.crawler.client.http.RequestHeader;
import org.codelibs.fess.crawler.entity.ExtractData;
import org.codelibs.fess.crawler.exception.ExtractException;
import org.codelibs.fess.crawler.extractor.impl.AbstractExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiExtractor
extends AbstractExtractor {
    private static final Logger logger = LoggerFactory.getLogger(ApiExtractor.class);
    protected String url;
    protected Integer accessTimeout;
    protected CloseableHttpClient httpClient;
    protected Integer connectionTimeout;
    protected Integer soTimeout;
    protected Map<String, AuthSchemeProvider> authSchemeProviderMap;
    protected String userAgent = "Crawler";
    protected CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
    protected AuthCache authCache = new BasicAuthCache();
    protected HttpClientContext httpClientContext = HttpClientContext.create();
    private final Map<String, Object> httpClientPropertyMap = new HashMap<String, Object>();
    private final List<Header> requestHeaderList = new ArrayList<Header>();

    @PostConstruct
    public void init() {
        RequestHeader[] requestHeaderArray;
        Authentication[] siteCredentialList;
        Integer soTimeoutParam;
        if (logger.isDebugEnabled()) {
            logger.debug("Initializing {}", (Object)ApiExtractor.class.getName());
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        Integer connectionTimeoutParam = this.connectionTimeout;
        if (connectionTimeoutParam != null) {
            requestConfigBuilder.setConnectTimeout(connectionTimeoutParam.intValue());
        }
        if ((soTimeoutParam = this.soTimeout) != null) {
            requestConfigBuilder.setSocketTimeout(soTimeoutParam.intValue());
        }
        RegistryBuilder authSchemeProviderBuilder = RegistryBuilder.create();
        Map<String, AuthSchemeProvider> factoryMap = this.authSchemeProviderMap;
        if (factoryMap != null) {
            for (Map.Entry<String, AuthSchemeProvider> entry : factoryMap.entrySet()) {
                authSchemeProviderBuilder.register(entry.getKey(), (Object)entry.getValue());
            }
        }
        if (StringUtil.isNotBlank((String)this.userAgent)) {
            httpClientBuilder.setUserAgent(this.userAgent);
        }
        for (Authentication authentication : siteCredentialList = new Authentication[0]) {
            AuthScope authScope = authentication.getAuthScope();
            this.credentialsProvider.setCredentials(authScope, authentication.getCredentials());
            AuthScheme authScheme = authentication.getAuthScheme();
            if (authScope.getHost() == null || authScheme == null) continue;
            HttpHost targetHost = new HttpHost(authScope.getHost(), authScope.getPort());
            this.authCache.put(targetHost, authScheme);
        }
        this.httpClientContext.setAuthCache(this.authCache);
        this.httpClientContext.setCredentialsProvider(this.credentialsProvider);
        for (RequestHeader requestHeader : requestHeaderArray = new RequestHeader[]{new RequestHeader("enctype", "multipart/form-data")}) {
            if (!requestHeader.isValid()) continue;
            this.requestHeaderList.add((Header)new BasicHeader(requestHeader.getName(), requestHeader.getValue()));
        }
        CloseableHttpClient closeableHttpClient = httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build()).build();
        if (!this.httpClientPropertyMap.isEmpty()) {
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(closeableHttpClient.getClass());
            for (Map.Entry<String, Object> entry : this.httpClientPropertyMap.entrySet()) {
                String propertyName = entry.getKey();
                if (beanDesc.hasPropertyDesc(propertyName)) {
                    PropertyDesc propertyDesc = beanDesc.getPropertyDesc(propertyName);
                    propertyDesc.setValue((Object)closeableHttpClient, entry.getValue());
                    continue;
                }
                logger.warn("DefaultHttpClient does not have {}.", (Object)propertyName);
            }
        }
        this.httpClient = closeableHttpClient;
    }

    @PreDestroy
    public void destroy() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                logger.error("Failed to close httpClient.", (Throwable)e);
            }
        }
    }

    @Override
    public ExtractData getText(InputStream in, Map<String, String> params) {
        if (logger.isDebugEnabled()) {
            logger.debug("Accessing {}", (Object)this.url);
        }
        AccessTimeoutTarget accessTimeoutTarget = null;
        TimeoutTask accessTimeoutTask = null;
        if (this.accessTimeout != null) {
            accessTimeoutTarget = new AccessTimeoutTarget(Thread.currentThread());
            accessTimeoutTask = TimeoutManager.getInstance().addTimeoutTarget((TimeoutTarget)accessTimeoutTarget, this.accessTimeout.intValue(), false);
        }
        ExtractData data = new ExtractData();
        HttpPost httpPost = new HttpPost(this.url);
        HttpEntity postEntity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).setCharset(Charset.forName("UTF-8")).addBinaryBody("filedata", in).build();
        httpPost.setEntity(postEntity);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            Header[] headers;
            if (response.getStatusLine().getStatusCode() != 200) {
                logger.error("Failed to access {}, code: {}.", (Object)this.url, (Object)response.getStatusLine().getStatusCode());
                ExtractData extractData = null;
                return extractData;
            }
            data.setContent(EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charsets.UTF_8));
            for (Header header : headers = response.getAllHeaders()) {
                data.putValue(header.getName(), header.getValue());
            }
        }
        catch (IOException e) {
            throw new ExtractException(e);
        }
        finally {
            if (this.accessTimeout != null) {
                accessTimeoutTarget.stop();
                if (!accessTimeoutTask.isCanceled()) {
                    accessTimeoutTask.cancel();
                }
            }
        }
        return data;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setSoTimeout(Integer soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setAuthSchemeProviderMap(Map<String, AuthSchemeProvider> authSchemeProviderMap) {
        this.authSchemeProviderMap = authSchemeProviderMap;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setAuthCache(AuthCache authCache) {
        this.authCache = authCache;
    }

    public void setHttpClientContext(HttpClientContext httpClientContext) {
        this.httpClientContext = httpClientContext;
    }

    public void setAccessTimeout(Integer accessTimeout) {
        this.accessTimeout = accessTimeout;
    }
}

