/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.filter.impl;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.codelibs.fess.crawler.container.CrawlerContainer;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.filter.UrlFilter;
import org.codelibs.fess.crawler.service.UrlFilterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlFilterImpl
implements UrlFilter {
    private static final Logger logger = LoggerFactory.getLogger(UrlFilterImpl.class);
    @Resource
    protected CrawlerContainer crawlerContainer;
    protected String urlPattern = "^(.*:/+)([^/]*)(.*)$";
    protected String includeFilteringPattern;
    protected String excludeFilteringPattern;
    protected Set<String> cachedIncludeSet = new LinkedHashSet<String>();
    protected Set<String> cachedExcludeSet = new LinkedHashSet<String>();
    protected String sessionId;
    protected UrlFilterService urlFilterService;

    @Override
    public void addExclude(String urlPattern) {
        try {
            Pattern.compile(urlPattern);
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Invalid exclude pattern: {}", (Object)urlPattern);
            }
            return;
        }
        if (this.sessionId == null) {
            this.cachedExcludeSet.add(urlPattern);
        } else {
            this.getUrlFilterService().addExcludeUrlFilter(this.sessionId, urlPattern);
        }
    }

    @Override
    public void addInclude(String urlPattern) {
        try {
            Pattern.compile(urlPattern);
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Invalid include pattern: {}", (Object)urlPattern);
            }
            return;
        }
        if (this.sessionId == null) {
            this.cachedIncludeSet.add(urlPattern);
        } else {
            this.getUrlFilterService().addIncludeUrlFilter(this.sessionId, urlPattern);
        }
    }

    @Override
    public void clear() {
        this.cachedIncludeSet.clear();
        this.cachedExcludeSet.clear();
        if (this.sessionId != null) {
            this.getUrlFilterService().delete(this.sessionId);
        }
    }

    @Override
    public void init(String sessionId) {
        this.sessionId = sessionId;
        if (!this.cachedIncludeSet.isEmpty()) {
            try {
                this.getUrlFilterService().addIncludeUrlFilter(sessionId, this.cachedIncludeSet.stream().collect(Collectors.toList()));
            }
            catch (Exception e) {
                logger.warn("Failed to add include_urls on " + sessionId, (Throwable)e);
            }
            this.cachedIncludeSet.clear();
        }
        if (!this.cachedExcludeSet.isEmpty()) {
            try {
                this.getUrlFilterService().addExcludeUrlFilter(sessionId, this.cachedExcludeSet.stream().collect(Collectors.toList()));
            }
            catch (Exception e) {
                logger.warn("Failed to add exclude_urls on " + sessionId, (Throwable)e);
            }
            this.cachedExcludeSet.clear();
        }
    }

    @Override
    public boolean match(String url) {
        Matcher matcher;
        boolean match;
        List<Pattern> includeList = this.getUrlFilterService().getIncludeUrlPatternList(this.sessionId);
        List<Pattern> excludeList = this.getUrlFilterService().getExcludeUrlPatternList(this.sessionId);
        if (!includeList.isEmpty()) {
            match = false;
            for (Pattern pattern : includeList) {
                matcher = pattern.matcher(url);
                if (!matcher.matches()) continue;
                match = true;
            }
            if (!match) {
                return false;
            }
        }
        if (!excludeList.isEmpty()) {
            match = false;
            for (Pattern pattern : excludeList) {
                matcher = pattern.matcher(url);
                if (!matcher.matches()) continue;
                match = true;
            }
            if (match) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void processUrl(String url) {
        if (this.includeFilteringPattern != null) {
            this.addInclude(url.replaceAll(this.urlPattern, this.includeFilteringPattern));
        }
        if (this.excludeFilteringPattern != null) {
            this.addExclude(url.replaceAll(this.urlPattern, this.excludeFilteringPattern));
        }
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public String getIncludeFilteringPattern() {
        return this.includeFilteringPattern;
    }

    public void setIncludeFilteringPattern(String includeFilteringPattern) {
        this.includeFilteringPattern = includeFilteringPattern;
    }

    public String getExcludeFilteringPattern() {
        return this.excludeFilteringPattern;
    }

    public void setExcludeFilteringPattern(String excludeFilteringPattern) {
        this.excludeFilteringPattern = excludeFilteringPattern;
    }

    public UrlFilterService getUrlFilterService() {
        if (this.urlFilterService == null) {
            this.urlFilterService = (UrlFilterService)this.crawlerContainer.getComponent("urlFilterService");
            if (this.urlFilterService == null) {
                throw new CrawlerSystemException("urlFilterService is not found.");
            }
        }
        return this.urlFilterService;
    }

    public String toString() {
        return "UrlFilterImpl [urlPattern=" + this.urlPattern + ", includeFilteringPattern=" + this.includeFilteringPattern + ", excludeFilteringPattern=" + this.excludeFilteringPattern + ", cachedIncludeSet=" + this.cachedIncludeSet + ", cachedExcludeSet=" + this.cachedExcludeSet + ", sessionId=" + this.sessionId + ", urlFilterService=" + this.urlFilterService + "]";
    }
}

