/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.interval.impl;

import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.interval.IntervalController;

public abstract class AbstractIntervalController
implements IntervalController {
    protected boolean ignoreException = true;

    @Override
    public void delay(int type) {
        block10: {
            try {
                switch (type) {
                    case 1: {
                        this.delayBeforeProcessing();
                        break;
                    }
                    case 2: {
                        this.delayAfterProcessing();
                        break;
                    }
                    case 4: {
                        this.delayAtNoUrlInQueue();
                        break;
                    }
                    case 8: {
                        this.delayForWaitingNewUrl();
                        break;
                    }
                }
            }
            catch (CrawlerSystemException e) {
                if (!this.ignoreException) {
                    throw e;
                }
            }
            catch (Exception e) {
                if (this.ignoreException) break block10;
                throw new CrawlerSystemException("Could not stop a process.", e);
            }
        }
    }

    protected abstract void delayBeforeProcessing();

    protected abstract void delayAfterProcessing();

    protected abstract void delayAtNoUrlInQueue();

    protected abstract void delayForWaitingNewUrl();

    public boolean isIgnoreException() {
        return this.ignoreException;
    }

    public void setIgnoreException(boolean ignoreException) {
        this.ignoreException = ignoreException;
    }
}

