/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.transformer.impl;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathEvaluationResult;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathNodes;
import org.codelibs.core.beans.util.BeanUtil;
import org.codelibs.fess.crawler.Constants;
import org.codelibs.fess.crawler.entity.AccessResultData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.entity.ResultData;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.transformer.impl.HtmlTransformer;
import org.codelibs.fess.crawler.util.XmlUtil;
import org.codelibs.nekohtml.parsers.DOMParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XpathTransformer
extends HtmlTransformer {
    private static final Logger logger = LoggerFactory.getLogger(XpathTransformer.class);
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+", 8);
    protected Map<String, String> fieldRuleMap = new LinkedHashMap<String, String>();
    protected boolean trimSpaceEnabled = true;
    protected String charsetName = "UTF-8";
    protected Class<?> dataClass = null;

    @Override
    protected void storeData(ResponseData responseData, ResultData resultData) {
        DOMParser parser = this.getDomParser();
        try (InputStream in = responseData.getResponseBody();){
            InputSource is = new InputSource(in);
            if (responseData.getCharSet() != null) {
                is.setEncoding(responseData.getCharSet());
            }
            parser.parse(is);
        }
        catch (Exception e) {
            throw new CrawlingAccessException("Could not parse " + responseData.getUrl(), e);
        }
        Document document = parser.getDocument();
        StringBuilder buf = new StringBuilder(1000);
        buf.append(this.getResultDataHeader());
        for (Map.Entry<String, String> entry : this.fieldRuleMap.entrySet()) {
            String path = entry.getValue();
            try {
                XPathEvaluationResult<?> xObj = this.getXPathAPI().eval(document, path);
                switch (xObj.type()) {
                    case BOOLEAN: {
                        Boolean b = (Boolean)xObj.value();
                        buf.append(this.getResultDataBody(entry.getKey(), b.toString()));
                        break;
                    }
                    case NUMBER: {
                        Number d = (Number)xObj.value();
                        buf.append(this.getResultDataBody(entry.getKey(), d.toString()));
                        break;
                    }
                    case STRING: {
                        String str = (String)xObj.value();
                        buf.append(this.getResultDataBody(entry.getKey(), str.trim()));
                        break;
                    }
                    case NODESET: {
                        XPathNodes nodeList = (XPathNodes)xObj.value();
                        ArrayList<String> strList = new ArrayList<String>();
                        for (int i = 0; i < nodeList.size(); ++i) {
                            Node node = nodeList.get(i);
                            strList.add(node.getTextContent());
                        }
                        buf.append(this.getResultDataBody(entry.getKey(), strList));
                        break;
                    }
                    case NODE: {
                        Node node = (Node)xObj.value();
                        buf.append(this.getResultDataBody(entry.getKey(), node.getTextContent()));
                        break;
                    }
                    default: {
                        Object obj = xObj.value();
                        if (obj == null) {
                            obj = "";
                        }
                        buf.append(this.getResultDataBody(entry.getKey(), obj.toString()));
                        break;
                    }
                }
            }
            catch (XPathException e) {
                logger.warn("Could not parse a value of " + entry.getKey() + ":" + entry.getValue(), (Throwable)e);
            }
        }
        buf.append(this.getAdditionalData(responseData, document));
        buf.append(this.getResultDataFooter());
        String data = buf.toString().trim();
        try {
            resultData.setData(data.getBytes(this.charsetName));
        }
        catch (UnsupportedEncodingException e) {
            if (logger.isInfoEnabled()) {
                logger.info("Invalid charsetName: " + this.charsetName + ". Changed to UTF-8", (Throwable)e);
            }
            this.charsetName = Constants.UTF_8_CHARSET.name();
            resultData.setData(data.getBytes(Constants.UTF_8_CHARSET));
        }
        resultData.setEncoding(this.charsetName);
    }

    protected String getResultDataHeader() {
        return "<?xml version=\"1.0\"?>\n<doc>\n";
    }

    protected String getResultDataBody(String name, String value) {
        return "<field name=\"" + XmlUtil.escapeXml(name) + "\">" + this.trimSpace(XmlUtil.escapeXml(value != null ? value : "")) + "</field>\n";
    }

    protected String getResultDataBody(String name, List<String> values) {
        StringBuilder buf = new StringBuilder();
        buf.append("<list>");
        if (values != null && !values.isEmpty()) {
            for (String value : values) {
                buf.append("<item>");
                buf.append(this.trimSpace(XmlUtil.escapeXml(value)));
                buf.append("</item>");
            }
        }
        buf.append("</list>");
        return "<field name=\"" + XmlUtil.escapeXml(name) + "\">" + buf.toString().trim() + "</field>\n";
    }

    protected String getAdditionalData(ResponseData responseData, Document document) {
        return "";
    }

    protected String getResultDataFooter() {
        return "</doc>";
    }

    protected String trimSpace(String value) {
        if (this.trimSpaceEnabled) {
            Matcher matcher = SPACE_PATTERN.matcher(value);
            return matcher.replaceAll(" ").trim();
        }
        return value;
    }

    public void addFieldRule(String name, String xpath) {
        this.fieldRuleMap.put(name, xpath);
    }

    @Override
    public Object getData(AccessResultData<?> accessResultData) {
        if (this.dataClass == null) {
            return super.getData(accessResultData);
        }
        Map<String, Object> dataMap = XmlUtil.getDataMap(accessResultData);
        if (Map.class.equals(this.dataClass)) {
            return dataMap;
        }
        try {
            Object obj = this.dataClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            BeanUtil.copyMapToBean(dataMap, obj);
            return obj;
        }
        catch (Exception e) {
            throw new CrawlerSystemException("Could not create/copy a data map to " + this.dataClass, e);
        }
    }

    public Map<String, String> getFieldRuleMap() {
        return this.fieldRuleMap;
    }

    public void setFieldRuleMap(Map<String, String> fieldRuleMap) {
        this.fieldRuleMap = fieldRuleMap;
    }

    public boolean isTrimSpace() {
        return this.trimSpaceEnabled;
    }

    public void setTrimSpace(boolean trimSpace) {
        this.trimSpaceEnabled = trimSpace;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public Class<?> getDataClass() {
        return this.dataClass;
    }

    public void setDataClass(Class<?> dataClass) {
        this.dataClass = dataClass;
    }
}

