/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.util;

import org.codelibs.fess.crawler.CrawlerContext;
import org.codelibs.fess.crawler.entity.AccessResult;
import org.codelibs.fess.crawler.entity.UrlQueue;
import org.codelibs.fess.crawler.service.DataService;
import org.codelibs.fess.crawler.service.UrlQueueService;

public final class CrawlingParameterUtil {
    private static final ThreadLocal<UrlQueue<?>> URL_QUEUE_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<CrawlerContext> ROBOT_CONTEXT_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<UrlQueueService<UrlQueue<?>>> URL_QUEUE_SERVICE_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<DataService<AccessResult<?>>> DATA_SERVICE_THREAD_LOCAL = new ThreadLocal();

    private CrawlingParameterUtil() {
    }

    public static UrlQueue<?> getUrlQueue() {
        return URL_QUEUE_THREAD_LOCAL.get();
    }

    public static void setUrlQueue(UrlQueue<?> urlQueue) {
        if (urlQueue == null) {
            URL_QUEUE_THREAD_LOCAL.remove();
        } else {
            URL_QUEUE_THREAD_LOCAL.set(urlQueue);
        }
    }

    public static CrawlerContext getCrawlerContext() {
        return ROBOT_CONTEXT_THREAD_LOCAL.get();
    }

    public static void setCrawlerContext(CrawlerContext crawlerContext) {
        if (crawlerContext == null) {
            ROBOT_CONTEXT_THREAD_LOCAL.remove();
        } else {
            ROBOT_CONTEXT_THREAD_LOCAL.set(crawlerContext);
        }
    }

    public static UrlQueueService<UrlQueue<?>> getUrlQueueService() {
        return URL_QUEUE_SERVICE_THREAD_LOCAL.get();
    }

    public static void setUrlQueueService(UrlQueueService<UrlQueue<?>> urlQueueService) {
        if (urlQueueService == null) {
            URL_QUEUE_SERVICE_THREAD_LOCAL.remove();
        } else {
            URL_QUEUE_SERVICE_THREAD_LOCAL.set(urlQueueService);
        }
    }

    public static DataService<AccessResult<?>> getDataService() {
        return DATA_SERVICE_THREAD_LOCAL.get();
    }

    public static void setDataService(DataService<AccessResult<?>> dataService) {
        if (dataService == null) {
            DATA_SERVICE_THREAD_LOCAL.remove();
        } else {
            DATA_SERVICE_THREAD_LOCAL.set(dataService);
        }
    }
}

