/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.builder;

import org.codelibs.fess.crawler.entity.RequestData;

public final class RequestDataBuilder {
    private RequestDataBuilder() {
    }

    public static RequestDataContext newRequestData() {
        return new RequestDataContext();
    }

    public static class RequestDataContext {
        private final RequestData data = new RequestData();

        private RequestDataContext() {
        }

        public RequestDataContext method(String method) {
            if ("GET".equalsIgnoreCase(method)) {
                return this.get();
            }
            if ("HEAD".equalsIgnoreCase(method)) {
                return this.head();
            }
            if ("POST".equalsIgnoreCase(method)) {
                return this.post();
            }
            return this.get();
        }

        public RequestDataContext method(RequestData.Method method) {
            this.data.setMethod(method);
            return this;
        }

        public RequestDataContext get() {
            return this.method(RequestData.Method.GET);
        }

        public RequestDataContext head() {
            return this.method(RequestData.Method.HEAD);
        }

        public RequestDataContext post() {
            return this.method(RequestData.Method.POST);
        }

        public RequestDataContext url(String url) {
            this.data.setUrl(url);
            return this;
        }

        public RequestDataContext metaData(String metaData) {
            this.data.setMetaData(metaData);
            return this;
        }

        public RequestData build() {
            return this.data;
        }
    }
}

