/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client.http.ntlm;

import java.io.IOException;
import java.util.Base64;
import java.util.Properties;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.Configuration;
import jcifs.config.PropertyConfiguration;
import jcifs.context.BaseContext;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import org.apache.http.impl.auth.NTLMEngine;
import org.apache.http.impl.auth.NTLMEngineException;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;

public class JcifsEngine
implements NTLMEngine {
    protected static final int TYPE_1_FLAGS = -1610579452;
    protected BaseContext cifsContext;

    public JcifsEngine(Properties props) {
        try {
            this.cifsContext = new BaseContext((Configuration)new PropertyConfiguration(props));
        }
        catch (CIFSException e) {
            throw new CrawlingAccessException(e);
        }
    }

    public String generateType1Msg(String domain, String workstation) throws NTLMEngineException {
        Type1Message type1Message = new Type1Message((CIFSContext)this.cifsContext, -1610579452, domain, workstation);
        return Base64.getEncoder().encodeToString(type1Message.toByteArray());
    }

    public String generateType3Msg(String username, String password, String domain, String workstation, String challenge) throws NTLMEngineException {
        Type2Message type2Message;
        try {
            type2Message = new Type2Message(Base64.getDecoder().decode(challenge));
        }
        catch (IOException exception) {
            throw new NTLMEngineException("Invalid NTLM type 2 message", (Throwable)exception);
        }
        int type2Flags = type2Message.getFlags();
        int type3Flags = type2Flags & 0xFFFCFFFF;
        try {
            Type3Message type3Message = new Type3Message((CIFSContext)this.cifsContext, type2Message, null, password, domain, username, workstation, type3Flags);
            return Base64.getEncoder().encodeToString(type3Message.toByteArray());
        }
        catch (Exception e) {
            throw new CrawlingAccessException(e);
        }
    }
}

