/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.extractor.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.codelibs.fess.crawler.entity.ExtractData;
import org.codelibs.fess.crawler.exception.ExtractException;
import org.codelibs.fess.crawler.extractor.Extractor;
import org.codelibs.fess.crawler.extractor.ExtractorFactory;
import org.codelibs.fess.crawler.extractor.impl.AbstractExtractor;
import org.codelibs.fess.crawler.helper.MimeTypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmlExtractor
extends AbstractExtractor {
    private static final String[] DAY_OF_WEEK = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    private static final Logger logger = LoggerFactory.getLogger(EmlExtractor.class);
    protected Properties mailProperties = new Properties();

    @Override
    public ExtractData getText(InputStream in, Map<String, String> params) {
        Properties props = new Properties(this.mailProperties);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                props.put(entry.getKey(), entry.getValue());
            }
        }
        try {
            Session mailSession = Session.getDefaultInstance((Properties)props, null);
            MimeMessage message = new MimeMessage(mailSession, in);
            String content = this.getBodyText(message);
            ExtractData data = new ExtractData(content != null ? content : "");
            Enumeration headers = message.getAllHeaders();
            while (headers.hasMoreElements()) {
                Header header = (Header)headers.nextElement();
                data.putValue(header.getName(), header.getValue());
            }
            this.putValue(data, "Content-ID", message.getContentID());
            this.putValue(data, "Content-Language", message.getContentLanguage());
            this.putValue(data, "Content-MD5", message.getContentMD5());
            this.putValue(data, "Description", message.getDescription());
            this.putValue(data, "Disposition", message.getDisposition());
            this.putValue(data, "Encoding", message.getEncoding());
            this.putValue(data, "File-Name", message.getFileName());
            this.putValue(data, "From", message.getFrom());
            this.putValue(data, "Line-Count", message.getLineCount());
            this.putValue(data, "Message-ID", message.getMessageID());
            this.putValue(data, "Message-Number", message.getMessageNumber());
            this.putValue(data, "Received-Date", EmlExtractor.getReceivedDate((Message)message));
            this.putValue(data, "Reply-To", message.getReplyTo());
            this.putValue(data, "Sender", message.getSender());
            this.putValue(data, "Sent-Date", message.getSentDate());
            this.putValue(data, "Size", message.getSize());
            this.putValue(data, "Subject", message.getSubject());
            this.putValue(data, "Receipients", message.getAllRecipients());
            this.putValue(data, "To", message.getRecipients(Message.RecipientType.TO));
            this.putValue(data, "Cc", message.getRecipients(Message.RecipientType.CC));
            this.putValue(data, "Bcc", message.getRecipients(Message.RecipientType.BCC));
            return data;
        }
        catch (MessagingException e) {
            throw new ExtractException(e);
        }
    }

    protected void putValue(ExtractData data, String key, Object value) {
        block16: {
            try {
                if (value instanceof String) {
                    if ("Subject".equals(key)) {
                        data.putValue(key, this.getDecodeText(value.toString()));
                    } else {
                        data.putValue(key, value.toString());
                    }
                } else if (value instanceof String[]) {
                    data.putValues(key, (String[])value);
                } else if (value instanceof Integer) {
                    data.putValue(key, ((Integer)value).toString());
                } else if (value instanceof Address[]) {
                    int size = ((Address[])value).length;
                    String[] values = new String[size];
                    for (int i = 0; i < size; ++i) {
                        Address address = ((Address[])value)[i];
                        values[i] = this.getDecodeText(address.toString());
                    }
                    data.putValues(key, values);
                } else if (value instanceof Date) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                    sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                    data.putValue(key, sdf.format(value));
                } else if (value != null) {
                    data.putValue(key, value.toString());
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block16;
                logger.debug("Failed to put {}:{}", new Object[]{key, value, e});
            }
        }
    }

    protected String getDecodeText(String value) {
        if (value == null) {
            return "";
        }
        try {
            return MimeUtility.decodeText((String)value);
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("Invalid encoding.", (Throwable)e);
            return "";
        }
    }

    public Properties getMailProperties() {
        return this.mailProperties;
    }

    public void setMailProperties(Properties mailProperties) {
        this.mailProperties = mailProperties;
    }

    protected String getBodyText(MimeMessage message) {
        StringBuilder buf = new StringBuilder(1000);
        try {
            Object content = message.getContent();
            if (content instanceof Multipart) {
                Multipart multipart = (Multipart)content;
                int count = multipart.getCount();
                block2: for (int i = 0; i < count; ++i) {
                    BodyPart bodyPart = multipart.getBodyPart(i);
                    if ("attachment".equalsIgnoreCase(bodyPart.getDisposition())) {
                        this.appendAttachment(buf, bodyPart);
                        continue;
                    }
                    if (bodyPart.isMimeType("text/plain") || bodyPart.isMimeType("text/html")) {
                        buf.append(bodyPart.getContent().toString()).append(' ');
                        continue;
                    }
                    if (!bodyPart.isMimeType("multipart/alternative") || !(bodyPart.getContent() instanceof Multipart)) continue;
                    Multipart alternativePart = (Multipart)bodyPart.getContent();
                    for (int j = 0; j < alternativePart.getCount(); ++j) {
                        BodyPart innerBodyPart = alternativePart.getBodyPart(j);
                        if (!innerBodyPart.isMimeType("text/plain")) continue;
                        buf.append(innerBodyPart.getContent().toString()).append(' ');
                        continue block2;
                    }
                }
            } else if (content instanceof String) {
                buf.append(content.toString());
            }
        }
        catch (IOException | MessagingException e) {
            throw new ExtractException(e);
        }
        return buf.toString();
    }

    protected void appendAttachment(StringBuilder buf, BodyPart bodyPart) {
        block11: {
            MimeTypeHelper mimeTypeHelper = this.getMimeTypeHelper();
            ExtractorFactory extractorFactory = this.getExtractorFactory();
            try {
                Extractor extractor;
                String filename = this.getDecodeText(bodyPart.getFileName());
                String mimeType = mimeTypeHelper.getContentType(null, filename);
                if (mimeType == null || (extractor = extractorFactory.getExtractor(mimeType)) == null) break block11;
                try (InputStream in = bodyPart.getInputStream();){
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("resourceName", filename);
                    String content = extractor.getText(in, map).getContent();
                    buf.append(content).append(' ');
                }
                catch (Exception e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Exception in an internal extractor.", (Throwable)e);
                    }
                }
            }
            catch (MessagingException e) {
                if (!logger.isDebugEnabled()) break block11;
                logger.debug("Exception in parsing BodyPart.", (Throwable)e);
            }
        }
    }

    protected static Date getReceivedDate(Message message) throws MessagingException {
        Date today = new Date();
        String[] received = message.getHeader("received");
        if (received != null) {
            for (String v : received) {
                String dateStr = null;
                try {
                    dateStr = EmlExtractor.getDateString(v);
                    Date receivedDate = new MailDateFormat().parse(dateStr);
                    if (!receivedDate.after(today)) {
                        return receivedDate;
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static String getDateString(String text) {
        for (String dow : DAY_OF_WEEK) {
            int i = text.lastIndexOf(dow);
            if (i == -1) continue;
            return text.substring(i);
        }
        return null;
    }
}

