/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.helper;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.crawler.entity.SitemapFile;
import org.codelibs.fess.crawler.entity.SitemapSet;
import org.codelibs.fess.crawler.entity.SitemapUrl;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.exception.SitemapsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class SitemapsHelper {
    private static final Logger logger = LoggerFactory.getLogger(SitemapsHelper.class);
    protected int preloadSize = 512;

    public boolean isValid(InputStream in) {
        return this.isValid(in, true);
    }

    protected boolean isValid(InputStream in, boolean recursive) {
        BufferedInputStream bis = new BufferedInputStream(in);
        bis.mark(this.preloadSize);
        byte[] bytes = new byte[this.preloadSize];
        try {
            if (bis.read(bytes) == -1) {
                return false;
            }
            String preloadDate = new String(bytes, "UTF-8");
            if (preloadDate.indexOf("<urlset") >= 0 || preloadDate.indexOf("<sitemapindex") >= 0 || preloadDate.startsWith("http://") || preloadDate.startsWith("https://")) {
                return true;
            }
            bis.reset();
            return this.isValid(new GZIPInputStream(bis), false);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to validate a file.", (Throwable)e);
            }
            return false;
        }
    }

    public SitemapSet parse(InputStream in) {
        return this.parse(in, true);
    }

    protected SitemapSet parse(InputStream in, boolean recursive) {
        BufferedInputStream bis = new BufferedInputStream(in);
        bis.mark(this.preloadSize);
        String preloadDate = "";
        byte[] bytes = new byte[this.preloadSize];
        try {
            if (bis.read(bytes) == -1) {
                throw new CrawlingAccessException("No sitemaps data.");
            }
            preloadDate = new String(bytes, "UTF-8");
            if (preloadDate.indexOf("<urlset") >= 0) {
                bis.reset();
                return this.parseXmlSitemaps(bis);
            }
            if (preloadDate.indexOf("<sitemapindex") >= 0) {
                bis.reset();
                return this.parseXmlSitemapsIndex(bis);
            }
            if (preloadDate.startsWith("http://") || preloadDate.startsWith("https://")) {
                bis.reset();
                return this.parseTextSitemaps(bis);
            }
            bis.reset();
            return this.parse(new GZIPInputStream(bis), false);
        }
        catch (CrawlingAccessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CrawlingAccessException("Could not parse Sitemaps: " + preloadDate, e);
        }
    }

    protected SitemapSet parseTextSitemaps(InputStream in) {
        SitemapSet sitemapSet = new SitemapSet();
        sitemapSet.setType("UrlSet");
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            while ((line = br.readLine()) != null) {
                String url = line.trim();
                if (!StringUtil.isNotBlank((String)url) || !url.startsWith("http://") && !url.startsWith("https://")) continue;
                SitemapUrl sitemapUrl = new SitemapUrl();
                sitemapUrl.setLoc(url);
                sitemapSet.addSitemap(sitemapUrl);
            }
            return sitemapSet;
        }
        catch (Exception e) {
            throw new SitemapsException("Could not parse Text Sitemaps.", e);
        }
    }

    protected SitemapSet parseXmlSitemaps(InputStream in) {
        XmlSitemapsHandler handler = new XmlSitemapsHandler();
        try {
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            spfactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            spfactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            spfactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser parser = spfactory.newSAXParser();
            this.disableExternalResources(parser);
            parser.parse(in, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new SitemapsException("Could not parse XML Sitemaps.", e);
        }
        return handler.getSitemapSet();
    }

    protected void disableExternalResources(SAXParser parser) throws SAXNotRecognizedException, SAXNotSupportedException {
        block2: {
            try {
                parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Failed to set a property.", (Throwable)e);
            }
        }
    }

    protected SitemapSet parseXmlSitemapsIndex(InputStream in) {
        XmlSitemapsIndexHandler handler = new XmlSitemapsIndexHandler();
        try {
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            spfactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            spfactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            spfactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser parser = spfactory.newSAXParser();
            this.disableExternalResources(parser);
            parser.parse(in, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new SitemapsException("Could not parse XML Sitemaps Index.", e);
        }
        return handler.getSitemapSet();
    }

    public void setPreloadSize(int preloadSize) {
        this.preloadSize = preloadSize;
    }

    protected static class XmlSitemapsHandler
    extends DefaultHandler {
        private static final String PRIORITY_ELEMENT = "priority";
        private static final String CHANGEFREQ_ELEMENT = "changefreq";
        private static final String LASTMOD_ELEMENT = "lastmod";
        private static final String LOC_ELEMENT = "loc";
        private static final String URL_ELEMENT = "url";
        private SitemapSet sitemapSet;
        private SitemapUrl sitemapUrl;
        private StringBuilder buf;

        protected XmlSitemapsHandler() {
        }

        @Override
        public void startDocument() {
            this.sitemapSet = new SitemapSet();
            this.sitemapSet.setType("UrlSet");
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (URL_ELEMENT.equals(qName)) {
                this.sitemapUrl = new SitemapUrl();
            } else if (LOC_ELEMENT.equals(qName) || LASTMOD_ELEMENT.equals(qName) || CHANGEFREQ_ELEMENT.equals(qName) || PRIORITY_ELEMENT.equals(qName)) {
                this.buf = new StringBuilder();
            }
        }

        @Override
        public void characters(char[] ch, int offset, int length) {
            if (this.buf != null) {
                this.buf.append(new String(ch, offset, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (URL_ELEMENT.equals(qName)) {
                if (this.sitemapUrl != null) {
                    this.sitemapSet.addSitemap(this.sitemapUrl);
                }
                this.sitemapUrl = null;
            } else if (LOC_ELEMENT.equals(qName)) {
                if (this.buf != null) {
                    this.sitemapUrl.setLoc(this.buf.toString().trim());
                    this.buf = null;
                }
            } else if (LASTMOD_ELEMENT.equals(qName)) {
                if (this.buf != null) {
                    this.sitemapUrl.setLastmod(this.buf.toString().trim());
                    this.buf = null;
                }
            } else if (CHANGEFREQ_ELEMENT.equals(qName)) {
                if (this.buf != null) {
                    this.sitemapUrl.setChangefreq(this.buf.toString().trim());
                    this.buf = null;
                }
            } else if (PRIORITY_ELEMENT.equals(qName) && this.buf != null) {
                this.sitemapUrl.setPriority(this.buf.toString().trim());
                this.buf = null;
            }
        }

        @Override
        public void endDocument() {
        }

        public SitemapSet getSitemapSet() {
            return this.sitemapSet;
        }
    }

    protected static class XmlSitemapsIndexHandler
    extends DefaultHandler {
        private SitemapSet sitemapSet;
        private SitemapFile sitemapFile;
        private StringBuilder buf;

        protected XmlSitemapsIndexHandler() {
        }

        @Override
        public void startDocument() {
            this.sitemapSet = new SitemapSet();
            this.sitemapSet.setType("Index");
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("sitemap".equals(qName)) {
                this.sitemapFile = new SitemapFile();
            } else if ("loc".equals(qName) || "lastmod".equals(qName)) {
                this.buf = new StringBuilder();
            }
        }

        @Override
        public void characters(char[] ch, int offset, int length) {
            if (this.buf != null) {
                this.buf.append(new String(ch, offset, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("sitemap".equals(qName)) {
                if (this.sitemapFile != null) {
                    this.sitemapSet.addSitemap(this.sitemapFile);
                }
                this.sitemapFile = null;
            } else if ("loc".equals(qName)) {
                if (this.buf != null) {
                    this.sitemapFile.setLoc(this.buf.toString().trim());
                    this.buf = null;
                }
            } else if ("lastmod".equals(qName) && this.buf != null) {
                this.sitemapFile.setLastmod(this.buf.toString().trim());
                this.buf = null;
            }
        }

        @Override
        public void endDocument() {
        }

        public SitemapSet getSitemapSet() {
            return this.sitemapSet;
        }
    }
}

