/*
 * Copyright 2012-2023 CodeLibs Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.codelibs.fess.ds.atlassian.api.jira.search;

import java.util.List;

import org.codelibs.fess.ds.atlassian.api.jira.domain.Issue;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class SearchResponse {

    protected Long total;
    protected List<Issue> issues;

    public Long getTotal() {
        return total;
    }

    public List<Issue> getIssues() {
        return issues;
    }

    public static SearchResponse create(final List<Issue> issues) {
        final SearchResponse response = new SearchResponse();
        response.issues = issues;
        response.total = (long) issues.size();
        return response;
    }

}
