/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.atlassian;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.filter.UrlFilter;
import org.codelibs.fess.ds.AbstractDataStore;
import org.codelibs.fess.entity.DataStoreParams;
import org.codelibs.fess.util.ComponentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AtlassianDataStore
extends AbstractDataStore {
    private static final Logger logger = LoggerFactory.getLogger(AtlassianDataStore.class);
    protected static final String MIMETYPE_HTML = "text/html";
    protected static final String IGNORE_ERROR = "ignore_error";
    protected static final String INCLUDE_PATTERN = "include_pattern";
    protected static final String EXCLUDE_PATTERN = "exclude_pattern";
    protected static final String URL_FILTER = "url_filter";
    protected static final String NUMBER_OF_THREADS = "number_of_threads";
    protected static final String READ_INTERVAL = "read_interval";
    protected String extractorName = "tikaExtractor";

    public void setExtractorName(String extractorName) {
        this.extractorName = extractorName;
    }

    protected UrlFilter getUrlFilter(DataStoreParams paramMap) {
        String exclude;
        UrlFilter urlFilter = (UrlFilter)ComponentUtil.getComponent(UrlFilter.class);
        String include = paramMap.getAsString(INCLUDE_PATTERN);
        if (StringUtil.isNotBlank((String)include)) {
            urlFilter.addInclude(include);
        }
        if (StringUtil.isNotBlank((String)(exclude = paramMap.getAsString(EXCLUDE_PATTERN)))) {
            urlFilter.addExclude(exclude);
        }
        urlFilter.init(paramMap.getAsString("crawlingInfoId"));
        if (logger.isDebugEnabled()) {
            logger.debug("urlFilter: {}", (Object)urlFilter);
        }
        return urlFilter;
    }

    protected ExecutorService newFixedThreadPool(int nThreads) {
        if (logger.isDebugEnabled()) {
            logger.debug("Executor Thread Pool: {}", (Object)nThreads);
        }
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(nThreads), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    protected Integer getNumberOfThreads(DataStoreParams paramMap) {
        return Integer.parseInt(paramMap.getAsString(NUMBER_OF_THREADS, "1"));
    }

    protected boolean isIgnoreError(DataStoreParams paramMap) {
        return "true".equalsIgnoreCase(paramMap.getAsString(IGNORE_ERROR, "true"));
    }

    protected Map<String, Object> createConfigMap(DataStoreParams paramMap) {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put(IGNORE_ERROR, this.isIgnoreError(paramMap));
        configMap.put(URL_FILTER, this.getUrlFilter(paramMap));
        configMap.put(READ_INTERVAL, this.getReadInterval(paramMap));
        return configMap;
    }

    public String getExtractedTextFromHtml(String body) {
        return this.getExtractedText(body, MIMETYPE_HTML);
    }

    public String getExtractedText(String text, String mimeType) {
        String string;
        ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes());
        try {
            string = ComponentUtil.getExtractorFactory().builder((InputStream)in, null).mimeType(mimeType).extractorName(this.extractorName).extract().getContent();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                if (!ComponentUtil.getFessConfig().isCrawlerIgnoreContentException()) {
                    throw new CrawlingAccessException((Throwable)e);
                }
                if (logger.isDebugEnabled()) {
                    logger.warn("Could not get a text.", (Throwable)e);
                } else {
                    logger.warn("Could not get a text. {}", (Object)e.getMessage());
                }
                return "";
            }
        }
        ((InputStream)in).close();
        return string;
    }
}

