/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.atlassian;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.codelibs.core.exception.InterruptedRuntimeException;
import org.codelibs.fess.app.service.FailureUrlService;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.exception.MultipleCrawlingAccessException;
import org.codelibs.fess.crawler.filter.UrlFilter;
import org.codelibs.fess.ds.atlassian.AtlassianDataStore;
import org.codelibs.fess.ds.atlassian.api.confluence.ConfluenceClient;
import org.codelibs.fess.ds.atlassian.api.confluence.domain.Comment;
import org.codelibs.fess.ds.atlassian.api.confluence.domain.Content;
import org.codelibs.fess.ds.callback.IndexUpdateCallback;
import org.codelibs.fess.entity.DataStoreParams;
import org.codelibs.fess.es.config.exentity.CrawlingConfig;
import org.codelibs.fess.es.config.exentity.DataConfig;
import org.codelibs.fess.helper.CrawlerStatsHelper;
import org.codelibs.fess.util.ComponentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceDataStore
extends AtlassianDataStore {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceDataStore.class);
    protected static final String CONTENT = "content";
    protected static final String CONTENT_TITLE = "title";
    protected static final String CONTENT_BODY = "body";
    protected static final String CONTENT_COMMENTS = "comments";
    protected static final String CONTENT_LAST_MODIFIED = "last_modified";
    protected static final String CONTENT_VIEW_URL = "view_url";

    protected String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected void storeData(DataConfig dataConfig, IndexUpdateCallback callback, DataStoreParams paramMap, Map<String, String> scriptMap, Map<String, Object> defaultDataMap) {
        Map<String, Object> configMap = this.createConfigMap(paramMap);
        if (logger.isDebugEnabled()) {
            logger.debug("configMap: {}", configMap);
        }
        ExecutorService executorService = this.newFixedThreadPool(this.getNumberOfThreads(paramMap));
        try (ConfluenceClient client = this.createClient(paramMap);){
            client.getContents(content -> executorService.execute(() -> this.processContent(dataConfig, callback, configMap, paramMap, scriptMap, defaultDataMap, client, (Content)content)));
            client.getBlogContents(content -> executorService.execute(() -> this.processContent(dataConfig, callback, configMap, paramMap, scriptMap, defaultDataMap, client, (Content)content)));
            if (logger.isDebugEnabled()) {
                logger.debug("Shutting down thread executor.");
            }
            executorService.shutdown();
            executorService.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptedRuntimeException(e);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    protected ConfluenceClient createClient(DataStoreParams paramMap) {
        return new ConfluenceClient(paramMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processContent(DataConfig dataConfig, IndexUpdateCallback callback, Map<String, Object> configMap, DataStoreParams paramMap, Map<String, String> scriptMap, Map<String, Object> defaultDataMap, ConfluenceClient client, Content content) {
        CrawlerStatsHelper crawlerStatsHelper = ComponentUtil.getCrawlerStatsHelper();
        HashMap<String, Object> dataMap = new HashMap<String, Object>(defaultDataMap);
        String confluenceHome = client.getConfluenceHome();
        String url = this.getContentViewUrl(content, confluenceHome);
        CrawlerStatsHelper.StatsKeyObject statsKey = new CrawlerStatsHelper.StatsKeyObject(url);
        paramMap.put("crawler.stats.key", (Object)statsKey);
        try {
            Object v;
            crawlerStatsHelper.begin((Object)statsKey);
            UrlFilter urlFilter = (UrlFilter)configMap.get("url_filter");
            if (urlFilter != null && !urlFilter.match(url)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Not matched: {}", (Object)url);
                }
                crawlerStatsHelper.discard((Object)statsKey);
                return;
            }
            logger.info("Crawling URL: {}", (Object)url);
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>(defaultDataMap);
            HashMap<String, Object> contentMap = new HashMap<String, Object>();
            contentMap.put(CONTENT_TITLE, content.getTitle());
            contentMap.put(CONTENT_BODY, this.getExtractedTextFromHtml(content.getBody()));
            contentMap.put(CONTENT_COMMENTS, this.getContentComments(content, client));
            contentMap.put(CONTENT_LAST_MODIFIED, this.getLastModifiedAsDate(content.getLastModified()));
            contentMap.put(CONTENT_VIEW_URL, url);
            resultMap.put(CONTENT, contentMap);
            crawlerStatsHelper.record((Object)statsKey, CrawlerStatsHelper.StatsAction.PREPARED);
            if (logger.isDebugEnabled()) {
                logger.debug("contentMap: {}", contentMap);
            }
            String scriptType = this.getScriptType(paramMap);
            for (Map.Entry<String, String> entry : scriptMap.entrySet()) {
                Object convertValue = this.convertValue(scriptType, entry.getValue(), resultMap);
                if (convertValue == null) continue;
                dataMap.put(entry.getKey(), convertValue);
            }
            crawlerStatsHelper.record((Object)statsKey, CrawlerStatsHelper.StatsAction.EVALUATED);
            if (logger.isDebugEnabled()) {
                logger.debug("dataMap: {}", dataMap);
            }
            if ((v = dataMap.get("url")) instanceof String) {
                String statsUrl = (String)v;
                statsKey.setUrl(statsUrl);
            }
            callback.store(paramMap, dataMap);
            crawlerStatsHelper.record((Object)statsKey, CrawlerStatsHelper.StatsAction.FINISHED);
        }
        catch (CrawlingAccessException e) {
            Throwable cause;
            Throwable[] causes;
            logger.warn("Crawling Access Exception at : {}", dataMap, (Object)e);
            Throwable target = e;
            if (target instanceof MultipleCrawlingAccessException && (causes = ((MultipleCrawlingAccessException)target).getCauses()).length > 0) {
                target = causes[causes.length - 1];
            }
            String errorName = (cause = target.getCause()) != null ? cause.getClass().getCanonicalName() : target.getClass().getCanonicalName();
            FailureUrlService failureUrlService = (FailureUrlService)ComponentUtil.getComponent(FailureUrlService.class);
            failureUrlService.store((CrawlingConfig)dataConfig, errorName, url, target);
            crawlerStatsHelper.record((Object)statsKey, CrawlerStatsHelper.StatsAction.ACCESS_EXCEPTION);
        }
        catch (Throwable t) {
            logger.warn("Crawling Access Exception at : {}", dataMap, (Object)t);
            FailureUrlService failureUrlService = (FailureUrlService)ComponentUtil.getComponent(FailureUrlService.class);
            failureUrlService.store((CrawlingConfig)dataConfig, t.getClass().getCanonicalName(), url, t);
            crawlerStatsHelper.record((Object)statsKey, CrawlerStatsHelper.StatsAction.EXCEPTION);
        }
        finally {
            crawlerStatsHelper.done((Object)statsKey);
        }
    }

    protected String getContentComments(Content content, ConfluenceClient client) {
        StringBuilder sb = new StringBuilder();
        String id = content.getId();
        client.getContentComments(id, (Comment comment) -> {
            sb.append("\n\n");
            sb.append(this.getExtractedTextFromHtml(comment.getBody()));
        });
        return sb.toString();
    }

    protected Date getLastModifiedAsDate(Long date) {
        return new Date(date * 1000L);
    }

    protected String getContentViewUrl(Content content, String confluenceHome) {
        return confluenceHome + "/pages/viewpage.action?pageId=" + content.getId();
    }
}

