/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.atlassian;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.codelibs.core.exception.InterruptedRuntimeException;
import org.codelibs.fess.app.service.FailureUrlService;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.exception.MultipleCrawlingAccessException;
import org.codelibs.fess.crawler.filter.UrlFilter;
import org.codelibs.fess.ds.atlassian.AtlassianDataStore;
import org.codelibs.fess.ds.atlassian.api.jira.JiraClient;
import org.codelibs.fess.ds.atlassian.api.jira.domain.Issue;
import org.codelibs.fess.ds.callback.IndexUpdateCallback;
import org.codelibs.fess.entity.DataStoreParams;
import org.codelibs.fess.es.config.exentity.CrawlingConfig;
import org.codelibs.fess.es.config.exentity.DataConfig;
import org.codelibs.fess.helper.CrawlerStatsHelper;
import org.codelibs.fess.util.ComponentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraDataStore
extends AtlassianDataStore {
    private static final Logger logger = LoggerFactory.getLogger(JiraDataStore.class);
    protected static final String ISSUE = "issue";
    protected static final String ISSUE_SUMMARY = "summary";
    protected static final String ISSUE_DESCRIPTION = "description";
    protected static final String ISSUE_COMMENTS = "comments";
    protected static final String ISSUE_LAST_MODIFIED = "last_modified";
    protected static final String ISSUE_VIEW_URL = "view_url";

    protected String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected void storeData(DataConfig dataConfig, IndexUpdateCallback callback, DataStoreParams paramMap, Map<String, String> scriptMap, Map<String, Object> defaultDataMap) {
        Map<String, Object> configMap = this.createConfigMap(paramMap);
        if (logger.isDebugEnabled()) {
            logger.debug("configMap: {}", configMap);
        }
        ExecutorService executorService = this.newFixedThreadPool(this.getNumberOfThreads(paramMap));
        try (JiraClient client = this.createClient(paramMap);){
            client.getIssues(issue -> executorService.execute(() -> this.processIssue(dataConfig, callback, configMap, paramMap, scriptMap, defaultDataMap, client, (Issue)issue)));
            if (logger.isDebugEnabled()) {
                logger.debug("Shutting down thread executor.");
            }
            executorService.shutdown();
            executorService.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptedRuntimeException(e);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    protected JiraClient createClient(DataStoreParams paramMap) {
        return new JiraClient(paramMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processIssue(DataConfig dataConfig, IndexUpdateCallback callback, Map<String, Object> configMap, DataStoreParams paramMap, Map<String, String> scriptMap, Map<String, Object> defaultDataMap, JiraClient client, Issue issue) {
        CrawlerStatsHelper crawlerStatsHelper = ComponentUtil.getCrawlerStatsHelper();
        HashMap<String, Object> dataMap = new HashMap<String, Object>(defaultDataMap);
        String url = this.getIssueViewUrl(issue, client);
        CrawlerStatsHelper.StatsKeyObject statsKey = new CrawlerStatsHelper.StatsKeyObject(url);
        paramMap.put("crawler.stats.key", (Object)statsKey);
        try {
            Object v;
            crawlerStatsHelper.begin((Object)statsKey);
            UrlFilter urlFilter = (UrlFilter)configMap.get("url_filter");
            if (urlFilter != null && !urlFilter.match(url)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Not matched: {}", (Object)url);
                }
                crawlerStatsHelper.discard((Object)statsKey);
                return;
            }
            logger.info("Crawling URL: {}", (Object)url);
            LinkedHashMap resultMap = new LinkedHashMap(paramMap.asMap());
            HashMap<String, Object> issueMap = new HashMap<String, Object>();
            issueMap.put(ISSUE_SUMMARY, issue.getFields().getSummary());
            issueMap.put(ISSUE_DESCRIPTION, issue.getFields().getDescription());
            issueMap.put(ISSUE_COMMENTS, this.getIssueComments(issue, client));
            issueMap.put(ISSUE_LAST_MODIFIED, this.getIssueLastModified(issue));
            issueMap.put(ISSUE_VIEW_URL, url);
            resultMap.put(ISSUE, issueMap);
            crawlerStatsHelper.record((Object)statsKey, CrawlerStatsHelper.StatsAction.PREPARED);
            if (logger.isDebugEnabled()) {
                logger.debug("issueMap: {}", issueMap);
            }
            String scriptType = this.getScriptType(paramMap);
            for (Map.Entry<String, String> entry : scriptMap.entrySet()) {
                Object convertValue = this.convertValue(scriptType, entry.getValue(), resultMap);
                if (convertValue == null) continue;
                dataMap.put(entry.getKey(), convertValue);
            }
            crawlerStatsHelper.record((Object)statsKey, CrawlerStatsHelper.StatsAction.EVALUATED);
            if (logger.isDebugEnabled()) {
                logger.debug("dataMap: {}", dataMap);
            }
            if ((v = dataMap.get("url")) instanceof String) {
                String statsUrl = (String)v;
                statsKey.setUrl(statsUrl);
            }
            callback.store(paramMap, dataMap);
            crawlerStatsHelper.record((Object)statsKey, CrawlerStatsHelper.StatsAction.FINISHED);
        }
        catch (CrawlingAccessException e) {
            Throwable cause;
            Throwable[] causes;
            logger.warn("Crawling Access Exception at : {}", dataMap, (Object)e);
            Throwable target = e;
            if (target instanceof MultipleCrawlingAccessException && (causes = ((MultipleCrawlingAccessException)target).getCauses()).length > 0) {
                target = causes[causes.length - 1];
            }
            String errorName = (cause = target.getCause()) != null ? cause.getClass().getCanonicalName() : target.getClass().getCanonicalName();
            FailureUrlService failureUrlService = (FailureUrlService)ComponentUtil.getComponent(FailureUrlService.class);
            failureUrlService.store((CrawlingConfig)dataConfig, errorName, url, target);
            crawlerStatsHelper.record((Object)statsKey, CrawlerStatsHelper.StatsAction.ACCESS_EXCEPTION);
        }
        catch (Throwable t) {
            logger.warn("Crawling Access Exception at : {}", dataMap, (Object)t);
            FailureUrlService failureUrlService = (FailureUrlService)ComponentUtil.getComponent(FailureUrlService.class);
            failureUrlService.store((CrawlingConfig)dataConfig, t.getClass().getCanonicalName(), url, t);
            crawlerStatsHelper.record((Object)statsKey, CrawlerStatsHelper.StatsAction.EXCEPTION);
        }
        finally {
            crawlerStatsHelper.done((Object)statsKey);
        }
    }

    protected String getIssueViewUrl(Issue issue, JiraClient client) {
        return client.getJiraHome() + "/browse/" + issue.getKey();
    }

    protected String getIssueComments(Issue issue, JiraClient client) {
        StringBuilder sb = new StringBuilder();
        String id = issue.getId();
        client.getComments(id, comment -> {
            sb.append("\n\n");
            sb.append(this.getExtractedTextFromHtml(comment.getBody()));
        });
        return sb.toString();
    }

    protected Date getIssueLastModified(Issue issue) {
        String updated = issue.getFields().getUpdated();
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            return format.parse(updated);
        }
        catch (ParseException e) {
            logger.warn("Failed to parse: {}", (Object)updated, (Object)e);
            return null;
        }
    }
}

