/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.atlassian.api;

import org.codelibs.fess.ds.atlassian.AtlassianDataStoreException;
import org.codelibs.fess.ds.atlassian.api.AtlassianRequest;
import org.codelibs.fess.ds.atlassian.api.authentication.Authentication;
import org.codelibs.fess.ds.atlassian.api.authentication.BasicAuthentication;
import org.codelibs.fess.ds.atlassian.api.authentication.OAuthAuthentication;
import org.codelibs.fess.entity.DataStoreParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AtlassianClient {
    private static final Logger logger = LoggerFactory.getLogger(AtlassianClient.class);
    protected static final String HOME_PARAM = "home";
    protected static final String AUTH_TYPE_PARAM = "auth_type";
    protected static final String CONSUMER_KEY_PARAM = "oauth.consumer_key";
    protected static final String PRIVATE_KEY_PARAM = "oauth.private_key";
    protected static final String SECRET_PARAM = "oauth.secret";
    protected static final String ACCESS_TOKEN_PARAM = "oauth.access_token";
    protected static final String BASIC_USERNAME_PARAM = "basic.username";
    protected static final String BASIC_PASS_PARAM = "basic.password";
    protected static final String PROXY_HOST_PARAM = "proxy_host";
    protected static final String PROXY_PORT_PARAM = "proxy_port";
    protected static final String HTTP_CONNECTION_TIMEOUT = "connection_timeout";
    protected static final String HTTP_READ_TIMEOUT = "read_timeout";
    protected static final String BASIC = "basic";
    protected static final String OAUTH = "oauth";
    protected Authentication authentication;
    protected Integer connectionTimeout;
    protected Integer readTimeout;

    protected AtlassianClient(DataStoreParams paramMap) {
        String authType;
        String home = this.getHome(paramMap);
        if (home.isEmpty()) {
            logger.warn("parameter \"{}\" required", (Object)HOME_PARAM);
            return;
        }
        switch (authType = this.getAuthType(paramMap)) {
            case "basic": {
                String username = this.getBasicUsername(paramMap);
                String password = this.getBasicPass(paramMap);
                if (username.isEmpty() || password.isEmpty()) {
                    throw new AtlassianDataStoreException("parameter \"basic.username\" and \"basic.password required for Basic authentication.");
                }
                this.authentication = new BasicAuthentication(username, password);
                break;
            }
            case "oauth": {
                String consumerKey = this.getConsumerKey(paramMap);
                String privateKey = this.getPrivateKey(paramMap);
                String verifier = this.getSecret(paramMap);
                String accessToken = this.getAccessToken(paramMap);
                if (consumerKey.isEmpty() || privateKey.isEmpty() || verifier.isEmpty() || accessToken.isEmpty()) {
                    throw new AtlassianDataStoreException("parameter \"oauth.consumer_key\", \"oauth.private_key\", \"oauth.secret\" and \"oauth.access_token\" required for OAuth authentication.");
                }
                this.authentication = new OAuthAuthentication(consumerKey, privateKey, accessToken, verifier);
                break;
            }
            default: {
                throw new AtlassianDataStoreException("auth_type is empty or invalid.");
            }
        }
        String httpProxyHost = this.getProxyHost(paramMap);
        String httpProxyPort = this.getProxyPort(paramMap);
        if (!httpProxyHost.isEmpty()) {
            if (httpProxyPort.isEmpty()) {
                throw new AtlassianDataStoreException("proxy_port required.");
            }
            try {
                int port = Integer.parseInt(httpProxyPort);
                this.authentication.setHttpProxy(httpProxyHost, port);
            }
            catch (NumberFormatException e) {
                throw new AtlassianDataStoreException("parameter 'proxy_port' invalid.", e);
            }
        }
        if (paramMap.containsKey(HTTP_CONNECTION_TIMEOUT)) {
            this.connectionTimeout = Integer.parseInt(paramMap.getAsString(HTTP_CONNECTION_TIMEOUT));
        }
        if (paramMap.containsKey(HTTP_READ_TIMEOUT)) {
            this.readTimeout = Integer.parseInt(paramMap.getAsString(HTTP_READ_TIMEOUT));
        }
    }

    protected <T extends AtlassianRequest> T createRequest(T request) {
        request.setAuthentication(this.authentication);
        request.setAppHome(this.getAppHome());
        request.setConnectionTimeout(this.connectionTimeout);
        request.setReadTimeout(this.readTimeout);
        return request;
    }

    protected abstract String getAppHome();

    protected String getHome(DataStoreParams paramMap) {
        return paramMap.getAsString(HOME_PARAM, "");
    }

    private String getBasicUsername(DataStoreParams paramMap) {
        return paramMap.getAsString(BASIC_USERNAME_PARAM, "");
    }

    private String getBasicPass(DataStoreParams paramMap) {
        return paramMap.getAsString(BASIC_PASS_PARAM, "");
    }

    private String getConsumerKey(DataStoreParams paramMap) {
        return paramMap.getAsString(CONSUMER_KEY_PARAM, "");
    }

    private String getPrivateKey(DataStoreParams paramMap) {
        return paramMap.getAsString(PRIVATE_KEY_PARAM, "");
    }

    private String getSecret(DataStoreParams paramMap) {
        return paramMap.getAsString(SECRET_PARAM, "");
    }

    private String getAccessToken(DataStoreParams paramMap) {
        return paramMap.getAsString(ACCESS_TOKEN_PARAM, "");
    }

    private String getAuthType(DataStoreParams paramMap) {
        return paramMap.getAsString(AUTH_TYPE_PARAM, "");
    }

    private String getProxyHost(DataStoreParams paramMap) {
        return paramMap.getAsString(PROXY_HOST_PARAM, "");
    }

    private String getProxyPort(DataStoreParams paramMap) {
        return paramMap.getAsString(PROXY_PORT_PARAM, "");
    }
}

