/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.atlassian.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import java.util.Map;
import java.util.function.Function;
import net.minidev.json.JSONObject;
import org.codelibs.curl.Curl;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fess.ds.atlassian.AtlassianDataStoreException;
import org.codelibs.fess.ds.atlassian.api.authentication.Authentication;
import org.codelibs.fess.ds.atlassian.api.util.UrlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AtlassianRequest {
    private static final Logger logger = LoggerFactory.getLogger(AtlassianRequest.class);
    protected static final ObjectMapper mapper = new ObjectMapper();
    protected static final String GET = "GET";
    protected static final String POST = "POST";
    protected static final String PUT = "PUT";
    protected static final String DELETE = "DELETE";
    protected static final Function<String, CurlRequest> CURL_GET = Curl::get;
    protected static final Function<String, CurlRequest> CURL_POST = Curl::post;
    protected static final Function<String, CurlRequest> CURL_PUT = Curl::put;
    protected static final Function<String, CurlRequest> CURL_DELETE = Curl::delete;
    protected Authentication authentication;
    protected String appHome;
    protected Integer connectionTimeout;
    protected Integer readTimeout;

    public String appHome() {
        return this.appHome;
    }

    public abstract String getURL();

    public Map<String, String> getQueryParamMap() {
        return null;
    }

    public Map<String, Object> getBodyMap() {
        return null;
    }

    public CurlResponse getCurlResponse(String requestMethod) {
        switch (requestMethod) {
            case "GET": {
                return this.getCurlResponse(CURL_GET, GET);
            }
            case "DELETE": {
                return this.getCurlResponse(CURL_DELETE, DELETE);
            }
            case "POST": {
                return this.getCurlResponse(CURL_POST, POST);
            }
            case "PUT": {
                return this.getCurlResponse(CURL_PUT, PUT);
            }
        }
        throw new IllegalArgumentException("Invalid request method : " + requestMethod);
    }

    public CurlResponse getCurlResponse(Function<String, CurlRequest> method, String requestMethod) {
        try {
            StringBuilder urlBuf = new StringBuilder();
            urlBuf.append(this.getURL());
            String queryParams = UrlUtil.buildQueryParameters(this.getQueryParamMap());
            if (!queryParams.isEmpty()) {
                urlBuf.append('?').append(queryParams);
            }
            CurlRequest request = this.authentication.getCurlRequest(method, requestMethod, new URL(urlBuf.toString()));
            Map<String, Object> bodyMap = this.getBodyMap();
            if (bodyMap != null) {
                String source = new JSONObject(bodyMap).toJSONString();
                request.body(source);
            }
            request.onConnect((req, con) -> {
                if (logger.isDebugEnabled()) {
                    logger.debug("connectionTimeout: {}, readTimeout: {}", (Object)this.connectionTimeout, (Object)this.readTimeout);
                }
                if (this.connectionTimeout != null) {
                    con.setConnectTimeout(this.connectionTimeout);
                }
                if (this.readTimeout != null) {
                    con.setReadTimeout(this.readTimeout);
                }
            });
            return request.execute();
        }
        catch (Exception e) {
            throw new AtlassianDataStoreException("Failed to access " + this.getURL(), e);
        }
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public void setAppHome(String appHome) {
        this.appHome = appHome;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }
}

