/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.atlassian.api.authentication;

import java.net.URL;
import java.security.PrivateKey;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.fess.ds.atlassian.api.authentication.Authentication;
import org.codelibs.fess.ds.atlassian.api.util.OAuthUtil;

public class OAuthAuthentication
extends Authentication {
    protected final String consumerKey;
    protected final PrivateKey privateKey;
    protected final String token;
    protected final String verifier;

    public OAuthAuthentication(String consumerKey, String privateKey, String token, String verifier) {
        this.consumerKey = consumerKey;
        this.privateKey = OAuthUtil.getPrivateKey(privateKey);
        this.token = token;
        this.verifier = verifier;
    }

    @Override
    public CurlRequest getCurlRequest(Function<String, CurlRequest> method, String requestMethod, URL url) {
        CurlRequest request = method.apply(url.toString());
        request.header("Authorization", OAuthUtil.getAuthorizationHeader(this.consumerKey, this.privateKey, this.token, this.verifier, requestMethod, url));
        if (this.httpProxy != null) {
            request.proxy(this.httpProxy);
        }
        return request;
    }
}

