/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.atlassian.api.confluence;

import java.io.Closeable;
import java.util.List;
import java.util.function.Consumer;
import org.codelibs.fess.ds.atlassian.api.AtlassianClient;
import org.codelibs.fess.ds.atlassian.api.confluence.content.GetContentRequest;
import org.codelibs.fess.ds.atlassian.api.confluence.content.GetContentsRequest;
import org.codelibs.fess.ds.atlassian.api.confluence.content.GetContentsResponse;
import org.codelibs.fess.ds.atlassian.api.confluence.content.child.GetAttachmentsOfContentRequest;
import org.codelibs.fess.ds.atlassian.api.confluence.content.child.GetCommentsOfContentRequest;
import org.codelibs.fess.ds.atlassian.api.confluence.content.child.GetCommentsOfContentResponse;
import org.codelibs.fess.ds.atlassian.api.confluence.domain.Comment;
import org.codelibs.fess.ds.atlassian.api.confluence.domain.Content;
import org.codelibs.fess.ds.atlassian.api.confluence.space.GetSpaceRequest;
import org.codelibs.fess.ds.atlassian.api.confluence.space.GetSpacesRequest;
import org.codelibs.fess.entity.DataStoreParams;

public class ConfluenceClient
extends AtlassianClient
implements Closeable {
    protected static final String DEFAULT_CONTENT_LIMIT = "25";
    protected static final String CONTENT_LIMIT_PARAM = "content_limit";
    protected final String confluenceHome;
    protected final Integer contentLimit;

    public ConfluenceClient(DataStoreParams paramMap) {
        super(paramMap);
        this.confluenceHome = this.getHome(paramMap);
        this.contentLimit = this.getContentLimit(paramMap);
    }

    @Override
    public void close() {
    }

    public String getConfluenceHome() {
        return this.confluenceHome;
    }

    public Integer getContentLimit(DataStoreParams paramMap) {
        return Integer.parseInt(paramMap.getAsString(CONTENT_LIMIT_PARAM, DEFAULT_CONTENT_LIMIT));
    }

    public GetSpacesRequest spaces() {
        return this.createRequest(new GetSpacesRequest());
    }

    public GetSpaceRequest space(String spaceKey) {
        return this.createRequest(new GetSpaceRequest(spaceKey));
    }

    public GetContentsRequest contents() {
        return this.createRequest(new GetContentsRequest());
    }

    public GetContentRequest content(String contentId) {
        return this.createRequest(new GetContentRequest(contentId));
    }

    public GetCommentsOfContentRequest commentsOfContent(String contentId) {
        return this.createRequest(new GetCommentsOfContentRequest(contentId));
    }

    public GetAttachmentsOfContentRequest attachmentsOfContent(String contentId) {
        return this.createRequest(new GetAttachmentsOfContentRequest(contentId));
    }

    @Override
    protected String getAppHome() {
        return this.confluenceHome;
    }

    public void getContents(Consumer<Content> consumer) {
        int start = 0;
        while (true) {
            GetContentsResponse response = this.contents().start(start).limit(this.contentLimit).expand("space", "version", "body.view").execute();
            List<Content> contents = response.getContents();
            contents.forEach(consumer);
            if (contents.size() < this.contentLimit) break;
            start += this.contentLimit.intValue();
        }
    }

    public void getBlogContents(Consumer<Content> consumer) {
        int start = 0;
        while (true) {
            GetContentsResponse response = this.contents().start(start).limit(this.contentLimit).type("blogpost").expand("space", "version", "body.view").execute();
            List<Content> contents = response.getContents();
            contents.forEach(consumer);
            if (contents.size() < this.contentLimit) break;
            start += this.contentLimit.intValue();
        }
    }

    public void getContentComments(String id, Consumer<Comment> consumer) {
        int start = 0;
        while (true) {
            GetCommentsOfContentResponse response = this.commentsOfContent(id).start(start).limit(this.contentLimit).expand("body.view").execute();
            List<Comment> comments = response.getComments();
            comments.forEach(consumer);
            if (comments.size() < this.contentLimit) break;
            start += this.contentLimit.intValue();
        }
    }
}

