/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.atlassian.api.confluence.content;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.curl.CurlException;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fess.ds.atlassian.AtlassianDataStoreException;
import org.codelibs.fess.ds.atlassian.api.AtlassianRequest;
import org.codelibs.fess.ds.atlassian.api.confluence.content.GetContentResponse;
import org.codelibs.fess.ds.atlassian.api.confluence.domain.Content;

public class GetContentRequest
extends AtlassianRequest {
    private final String id;
    private String status;
    private Integer version;
    private String[] expand;

    public GetContentRequest(String id) {
        this.id = id;
    }

    public GetContentRequest status(String status) {
        this.status = status;
        return this;
    }

    public GetContentRequest version(int version) {
        this.version = version;
        return this;
    }

    public GetContentRequest expand(String ... expand) {
        this.expand = expand;
        return this;
    }

    public GetContentResponse execute() {
        GetContentResponse getContentResponse;
        block9: {
            CurlResponse response = this.getCurlResponse("GET");
            try {
                if (response.getHttpStatusCode() != 200) {
                    throw new CurlException("HTTP Status : " + response.getHttpStatusCode() + ", error : " + response.getContentAsString());
                }
                getContentResponse = GetContentRequest.parseResponse(response.getContentAsString());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AtlassianDataStoreException("Failed to access " + this, e);
                }
            }
            response.close();
        }
        return getContentResponse;
    }

    public static GetContentResponse parseResponse(String json) {
        if (StringUtil.isBlank((String)json)) {
            return new GetContentResponse(null);
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            return new GetContentResponse((Content)mapper.readValue(json, Content.class));
        }
        catch (IOException e) {
            throw new AtlassianDataStoreException("Failed to parse content from: " + json, e);
        }
    }

    @Override
    public String getURL() {
        return this.appHome + "/rest/api/latest/content/" + this.id;
    }

    @Override
    public Map<String, String> getQueryParamMap() {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.status != null) {
            queryParams.put("status", this.status);
        }
        if (this.version != null) {
            queryParams.put("version", this.version.toString());
        }
        if (this.expand != null) {
            queryParams.put("expand", String.join((CharSequence)",", this.expand));
        }
        return queryParams;
    }

    public String toString() {
        return "GetContentRequest [id=" + this.id + ", status=" + this.status + ", version=" + this.version + ", expand=" + Arrays.toString(this.expand) + "]";
    }
}

