/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.atlassian.api.confluence.content;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.curl.CurlException;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fess.ds.atlassian.AtlassianDataStoreException;
import org.codelibs.fess.ds.atlassian.api.AtlassianRequest;
import org.codelibs.fess.ds.atlassian.api.confluence.content.GetContentsResponse;
import org.codelibs.fess.ds.atlassian.api.confluence.domain.Content;

public class GetContentsRequest
extends AtlassianRequest {
    private String type;
    private String spaceKey;
    private String title;
    private String status;
    private String postingDay;
    private String[] expand;
    private Integer start;
    private Integer limit;

    public GetContentsRequest type(String type) {
        this.type = type;
        return this;
    }

    public GetContentsRequest spaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
        return this;
    }

    public GetContentsRequest title(String title) {
        this.title = title;
        return this;
    }

    public GetContentsRequest status(String status) {
        this.status = status;
        return this;
    }

    public GetContentsRequest postingDay(String postingDay) {
        this.postingDay = postingDay;
        return this;
    }

    public GetContentsRequest expand(String ... expand) {
        this.expand = expand;
        return this;
    }

    public GetContentsRequest start(int start) {
        this.start = start;
        return this;
    }

    public GetContentsRequest limit(int limit) {
        this.limit = limit;
        return this;
    }

    public GetContentsResponse execute() {
        GetContentsResponse getContentsResponse;
        block9: {
            CurlResponse response = this.getCurlResponse("GET");
            try {
                if (response.getHttpStatusCode() != 200) {
                    throw new CurlException("HTTP Status : " + response.getHttpStatusCode() + ", error : " + response.getContentAsString());
                }
                getContentsResponse = GetContentsRequest.parseResponse(response.getContentAsString());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AtlassianDataStoreException("Failed to access " + this, e);
                }
            }
            response.close();
        }
        return getContentsResponse;
    }

    public static GetContentsResponse parseResponse(String json) {
        if (StringUtil.isBlank((String)json)) {
            return new GetContentsResponse(Collections.emptyList());
        }
        try {
            String results = mapper.readTree(json).get("results").toString();
            ArrayList<Content> contents = new ArrayList<Content>((Collection)mapper.readValue(results, (TypeReference)new TypeReference<List<Content>>(){}));
            return new GetContentsResponse(contents);
        }
        catch (IOException e) {
            throw new AtlassianDataStoreException("Failed to parse contents from: " + json, e);
        }
    }

    @Override
    public String getURL() {
        return this.appHome + "/rest/api/latest/content";
    }

    @Override
    public Map<String, String> getQueryParamMap() {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.type != null) {
            queryParams.put("type", this.type);
        }
        if (this.spaceKey != null) {
            queryParams.put("spaceKey", this.spaceKey);
        }
        if (this.title != null) {
            queryParams.put("title", this.title);
        }
        if (this.status != null) {
            queryParams.put("status", this.status);
        }
        if (this.postingDay != null) {
            queryParams.put("postingDay", this.postingDay);
        }
        if (this.expand != null) {
            queryParams.put("expand", String.join((CharSequence)",", this.expand));
        }
        if (this.start != null) {
            queryParams.put("start", this.start.toString());
        }
        if (this.limit != null) {
            queryParams.put("limit", this.limit.toString());
        }
        return queryParams;
    }
}

