/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.atlassian.api.confluence.content.child;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.curl.CurlException;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fess.ds.atlassian.AtlassianDataStoreException;
import org.codelibs.fess.ds.atlassian.api.AtlassianRequest;
import org.codelibs.fess.ds.atlassian.api.confluence.content.child.GetAttachmentsOfContentResponse;
import org.codelibs.fess.ds.atlassian.api.confluence.domain.Attachment;

public class GetAttachmentsOfContentRequest
extends AtlassianRequest {
    private final String id;
    private Integer start;
    private Integer limit;
    private String filename;
    private String mediaType;
    private String[] expand;

    public GetAttachmentsOfContentRequest(String id) {
        this.id = id;
    }

    public GetAttachmentsOfContentRequest start(int start) {
        this.start = start;
        return this;
    }

    public GetAttachmentsOfContentRequest limit(int limit) {
        this.limit = limit;
        return this;
    }

    public GetAttachmentsOfContentRequest filename(String filename) {
        this.filename = filename;
        return this;
    }

    public GetAttachmentsOfContentRequest mediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public GetAttachmentsOfContentRequest expand(String ... expand) {
        this.expand = expand;
        return this;
    }

    public GetAttachmentsOfContentResponse execute() {
        GetAttachmentsOfContentResponse getAttachmentsOfContentResponse;
        block9: {
            CurlResponse response = this.getCurlResponse("GET");
            try {
                if (response.getHttpStatusCode() != 200) {
                    throw new CurlException("HTTP Status : " + response.getHttpStatusCode() + ", error : " + response.getContentAsString());
                }
                getAttachmentsOfContentResponse = GetAttachmentsOfContentRequest.parseResponse(response.getContentAsString());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AtlassianDataStoreException("Failed to access " + this, e);
                }
            }
            response.close();
        }
        return getAttachmentsOfContentResponse;
    }

    public static GetAttachmentsOfContentResponse parseResponse(String json) {
        if (StringUtil.isBlank((String)json)) {
            return new GetAttachmentsOfContentResponse(Collections.emptyList());
        }
        try {
            String results = mapper.readTree(json).get("results").toString();
            return new GetAttachmentsOfContentResponse((List)mapper.readValue(results, (TypeReference)new TypeReference<List<Attachment>>(){}));
        }
        catch (IOException e) {
            throw new AtlassianDataStoreException("Failed to parse attachments from: " + json, e);
        }
    }

    @Override
    public String getURL() {
        return this.appHome + "/rest/api/latest/content/" + this.id + "/child/attachment";
    }

    @Override
    public Map<String, String> getQueryParamMap() {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.start != null) {
            queryParams.put("start", this.start.toString());
        }
        if (this.limit != null) {
            queryParams.put("limit", this.limit.toString());
        }
        if (this.filename != null) {
            queryParams.put("filename", this.filename);
        }
        if (this.mediaType != null) {
            queryParams.put("mediaType", this.mediaType);
        }
        if (this.expand != null) {
            queryParams.put("expand", String.join((CharSequence)",", this.expand));
        }
        return queryParams;
    }

    public String toString() {
        return "GetAttachmentsOfContentRequest [id=" + this.id + ", start=" + this.start + ", limit=" + this.limit + ", filename=" + this.filename + ", mediaType=" + this.mediaType + ", expand=" + Arrays.toString(this.expand) + "]";
    }
}

