/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.atlassian.api.confluence.content.child;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.curl.CurlException;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fess.ds.atlassian.AtlassianDataStoreException;
import org.codelibs.fess.ds.atlassian.api.AtlassianRequest;
import org.codelibs.fess.ds.atlassian.api.confluence.content.child.GetCommentsOfContentResponse;
import org.codelibs.fess.ds.atlassian.api.confluence.domain.Comment;

public class GetCommentsOfContentRequest
extends AtlassianRequest {
    private final String id;
    private Integer parentVersion;
    private Integer start;
    private Integer limit;
    private String location;
    private String depth;
    private String[] expand;

    public GetCommentsOfContentRequest(String id) {
        this.id = id;
    }

    public GetCommentsOfContentRequest parentVersion(int parentVersion) {
        this.parentVersion = parentVersion;
        return this;
    }

    public GetCommentsOfContentRequest start(int start) {
        this.start = start;
        return this;
    }

    public GetCommentsOfContentRequest limit(int limit) {
        this.limit = limit;
        return this;
    }

    public GetCommentsOfContentRequest location(String location) {
        this.location = location;
        return this;
    }

    public GetCommentsOfContentRequest depth(String depth) {
        this.depth = depth;
        return this;
    }

    public GetCommentsOfContentRequest expand(String ... expand) {
        this.expand = expand;
        return this;
    }

    public GetCommentsOfContentResponse execute() {
        GetCommentsOfContentResponse getCommentsOfContentResponse;
        block9: {
            CurlResponse response = this.getCurlResponse("GET");
            try {
                if (response.getHttpStatusCode() != 200) {
                    throw new CurlException("HTTP Status : " + response.getHttpStatusCode() + ", error : " + response.getContentAsString());
                }
                getCommentsOfContentResponse = GetCommentsOfContentRequest.parseResponse(response.getContentAsString());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AtlassianDataStoreException("Failed to access " + this, e);
                }
            }
            response.close();
        }
        return getCommentsOfContentResponse;
    }

    public static GetCommentsOfContentResponse parseResponse(String json) {
        if (StringUtil.isBlank((String)json)) {
            return new GetCommentsOfContentResponse(Collections.emptyList());
        }
        try {
            String results = mapper.readTree(json).get("results").toString();
            ArrayList<Comment> comments = new ArrayList<Comment>((Collection)mapper.readValue(results, (TypeReference)new TypeReference<List<Comment>>(){}));
            return new GetCommentsOfContentResponse(comments);
        }
        catch (IOException e) {
            throw new AtlassianDataStoreException("Failed to parse comments from: " + json, e);
        }
    }

    @Override
    public String getURL() {
        return this.appHome + "/rest/api/latest/content/" + this.id + "/child/comment";
    }

    @Override
    public Map<String, String> getQueryParamMap() {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.parentVersion != null) {
            queryParams.put("parentVersion", this.parentVersion.toString());
        }
        if (this.start != null) {
            queryParams.put("start", this.start.toString());
        }
        if (this.limit != null) {
            queryParams.put("limit", this.limit.toString());
        }
        if (this.location != null) {
            queryParams.put("location", this.location);
        }
        if (this.depth != null) {
            queryParams.put("depth", this.depth);
        }
        if (this.expand != null) {
            queryParams.put("expand", String.join((CharSequence)",", this.expand));
        }
        return queryParams;
    }

    public String toString() {
        return "GetCommentsOfContentRequest [id=" + this.id + ", parentVersion=" + this.parentVersion + ", start=" + this.start + ", limit=" + this.limit + ", location=" + this.location + ", depth=" + this.depth + ", expand=" + Arrays.toString(this.expand) + "]";
    }
}

