/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.atlassian.api.confluence.space;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.curl.CurlException;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fess.ds.atlassian.AtlassianDataStoreException;
import org.codelibs.fess.ds.atlassian.api.AtlassianRequest;
import org.codelibs.fess.ds.atlassian.api.confluence.domain.Space;
import org.codelibs.fess.ds.atlassian.api.confluence.space.GetSpaceResponse;

public class GetSpaceRequest
extends AtlassianRequest {
    private final String spaceKey;
    private String[] expand;

    public GetSpaceRequest(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public GetSpaceRequest expand(String ... expand) {
        this.expand = expand;
        return this;
    }

    public GetSpaceResponse execute() {
        GetSpaceResponse getSpaceResponse;
        block9: {
            CurlResponse response = this.getCurlResponse("GET");
            try {
                if (response.getHttpStatusCode() != 200) {
                    throw new CurlException("HTTP Status : " + response.getHttpStatusCode() + ", error : " + response.getContentAsString());
                }
                getSpaceResponse = GetSpaceRequest.parseResponse(response.getContentAsString());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AtlassianDataStoreException("Failed to access " + this, e);
                }
            }
            response.close();
        }
        return getSpaceResponse;
    }

    public static GetSpaceResponse parseResponse(String json) {
        if (StringUtil.isBlank((String)json)) {
            return new GetSpaceResponse(null);
        }
        try {
            return new GetSpaceResponse((Space)mapper.readValue(json, Space.class));
        }
        catch (IOException e) {
            throw new AtlassianDataStoreException("Failed to parse space from: " + json, e);
        }
    }

    @Override
    public String getURL() {
        return this.appHome + "/rest/api/latest/space/" + this.spaceKey;
    }

    @Override
    public Map<String, String> getQueryParamMap() {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.expand != null) {
            queryParams.put("expand", String.join((CharSequence)",", this.expand));
        }
        return queryParams;
    }
}

