/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.atlassian.api.confluence.space;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.curl.CurlException;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fess.ds.atlassian.AtlassianDataStoreException;
import org.codelibs.fess.ds.atlassian.api.AtlassianRequest;
import org.codelibs.fess.ds.atlassian.api.confluence.domain.Space;
import org.codelibs.fess.ds.atlassian.api.confluence.space.GetSpacesResponse;

public class GetSpacesRequest
extends AtlassianRequest {
    private String spaceKey;
    private String type;
    private String status;
    private String label;
    private String favourite;
    private String[] expand;
    private Integer start;
    private Integer limit;

    public GetSpacesRequest spaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
        return this;
    }

    public GetSpacesRequest type(String type) {
        this.type = type;
        return this;
    }

    public GetSpacesRequest status(String status) {
        this.status = status;
        return this;
    }

    public GetSpacesRequest label(String label) {
        this.label = label;
        return this;
    }

    public GetSpacesRequest favourite(String favourite) {
        this.favourite = favourite;
        return this;
    }

    public GetSpacesRequest expand(String ... expand) {
        this.expand = expand;
        return this;
    }

    public GetSpacesRequest start(int start) {
        this.start = start;
        return this;
    }

    public GetSpacesRequest limit(int limit) {
        this.limit = limit;
        return this;
    }

    public GetSpacesResponse execute() {
        GetSpacesResponse getSpacesResponse;
        block9: {
            CurlResponse response = this.getCurlResponse("GET");
            try {
                if (response.getHttpStatusCode() != 200) {
                    throw new CurlException("HTTP Status : " + response.getHttpStatusCode() + ", error : " + response.getContentAsString());
                }
                getSpacesResponse = GetSpacesRequest.parseResponse(response.getContentAsString());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AtlassianDataStoreException("Failed to access " + this, e);
                }
            }
            response.close();
        }
        return getSpacesResponse;
    }

    public static GetSpacesResponse parseResponse(String json) {
        if (StringUtil.isBlank((String)json)) {
            return new GetSpacesResponse(Collections.emptyList());
        }
        try {
            String results = mapper.readTree(json).get("results").toString();
            ArrayList<Space> spaces = new ArrayList<Space>((Collection)mapper.readValue(results, (TypeReference)new TypeReference<List<Space>>(){}));
            return new GetSpacesResponse(spaces);
        }
        catch (IOException e) {
            throw new AtlassianDataStoreException("Failed to parse spaces from: " + json, e);
        }
    }

    @Override
    public String getURL() {
        return this.appHome + "/rest/api/latest/space";
    }

    @Override
    public Map<String, String> getQueryParamMap() {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.spaceKey != null) {
            queryParams.put("spaceKey", this.spaceKey);
        }
        if (this.type != null) {
            queryParams.put("type", this.type);
        }
        if (this.status != null) {
            queryParams.put("status", this.status);
        }
        if (this.label != null) {
            queryParams.put("label", this.label);
        }
        if (this.favourite != null) {
            queryParams.put("favourite", this.favourite);
        }
        if (this.expand != null) {
            queryParams.put("expand", String.join((CharSequence)",", this.expand));
        }
        if (this.start != null) {
            queryParams.put("start", this.start.toString());
        }
        if (this.limit != null) {
            queryParams.put("limit", this.limit.toString());
        }
        return queryParams;
    }
}

