/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.atlassian.api.jira;

import java.io.Closeable;
import java.util.List;
import java.util.function.Consumer;
import org.codelibs.fess.ds.atlassian.api.AtlassianClient;
import org.codelibs.fess.ds.atlassian.api.jira.domain.Comment;
import org.codelibs.fess.ds.atlassian.api.jira.domain.Issue;
import org.codelibs.fess.ds.atlassian.api.jira.issue.GetCommentsRequest;
import org.codelibs.fess.ds.atlassian.api.jira.issue.GetCommentsResponse;
import org.codelibs.fess.ds.atlassian.api.jira.issue.GetIssueRequest;
import org.codelibs.fess.ds.atlassian.api.jira.project.GetProjectRequest;
import org.codelibs.fess.ds.atlassian.api.jira.project.GetProjectsRequest;
import org.codelibs.fess.ds.atlassian.api.jira.search.SearchRequest;
import org.codelibs.fess.ds.atlassian.api.jira.search.SearchResponse;
import org.codelibs.fess.entity.DataStoreParams;

public class JiraClient
extends AtlassianClient
implements Closeable {
    protected static final String DEFAULT_ISSUE_MAX_RESULTS = "50";
    protected static final String JQL_PARAM = "issue.jql";
    protected static final String ISSUE_MAX_RESULTS_PARAM = "issue_max_results";
    protected final String jiraHome;
    protected final String jql;
    protected final Integer issueMaxResults;

    public JiraClient(DataStoreParams paramMap) {
        super(paramMap);
        this.jiraHome = this.getHome(paramMap);
        this.jql = this.getJql(paramMap);
        this.issueMaxResults = this.getIssueMaxResults(paramMap);
    }

    @Override
    public void close() {
    }

    protected String getJql(DataStoreParams paramMap) {
        return paramMap.getAsString(JQL_PARAM);
    }

    protected Integer getIssueMaxResults(DataStoreParams paramMap) {
        return Integer.parseInt(paramMap.getAsString(ISSUE_MAX_RESULTS_PARAM, DEFAULT_ISSUE_MAX_RESULTS));
    }

    public String getJiraHome() {
        return this.jiraHome;
    }

    public GetProjectsRequest projects() {
        return this.createRequest(new GetProjectsRequest());
    }

    public GetProjectRequest project(String projectIdOrKey) {
        return this.createRequest(new GetProjectRequest(projectIdOrKey));
    }

    public SearchRequest search() {
        return this.createRequest(new SearchRequest());
    }

    public GetIssueRequest issue(String issueIdOrKey) {
        return this.createRequest(new GetIssueRequest(issueIdOrKey));
    }

    public GetCommentsRequest comments(String issueIdOrKey) {
        return this.createRequest(new GetCommentsRequest(issueIdOrKey));
    }

    @Override
    protected String getAppHome() {
        return this.jiraHome;
    }

    public void getIssues(Consumer<Issue> consumer) {
        int startAt = 0;
        while (true) {
            SearchResponse searchResponse = this.search().jql(this.jql).startAt(startAt).maxResults(this.issueMaxResults).fields("summary", "description", "updated").execute();
            searchResponse.getIssues().forEach(consumer);
            if (searchResponse.getTotal() < (long)this.issueMaxResults.intValue()) break;
            startAt += this.issueMaxResults.intValue();
        }
    }

    public void getComments(String issueId, Consumer<Comment> consumer) {
        int startAt = 0;
        while (true) {
            GetCommentsResponse getCommentsResponse = this.comments(issueId).startAt(startAt).maxResults(this.issueMaxResults).execute();
            List<Comment> comments = getCommentsResponse.getComments();
            comments.forEach(consumer);
            if (comments.size() < this.issueMaxResults) break;
            startAt += this.issueMaxResults.intValue();
        }
    }
}

