/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.atlassian.api.jira.issue;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.curl.CurlException;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fess.ds.atlassian.AtlassianDataStoreException;
import org.codelibs.fess.ds.atlassian.api.AtlassianRequest;
import org.codelibs.fess.ds.atlassian.api.jira.domain.Comments;
import org.codelibs.fess.ds.atlassian.api.jira.issue.GetCommentsResponse;

public class GetCommentsRequest
extends AtlassianRequest {
    private final String issueIdOrKey;
    private Long startAt;
    private Integer maxResults;
    private String orderBy;
    private String[] expand;

    public GetCommentsRequest(String issueIdOrKey) {
        this.issueIdOrKey = issueIdOrKey;
    }

    public GetCommentsRequest startAt(long startAt) {
        this.startAt = startAt;
        return this;
    }

    public GetCommentsRequest maxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public GetCommentsRequest orderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public GetCommentsRequest expand(String ... expand) {
        this.expand = expand;
        return this;
    }

    public GetCommentsResponse execute() {
        GetCommentsResponse getCommentsResponse;
        block9: {
            CurlResponse response = this.getCurlResponse("GET");
            try {
                if (response.getHttpStatusCode() != 200) {
                    throw new CurlException("HTTP Status : " + response.getHttpStatusCode() + ", error : " + response.getContentAsString());
                }
                getCommentsResponse = GetCommentsRequest.parseResponse(response.getContentAsString());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AtlassianDataStoreException("Failed to access " + this, e);
                }
            }
            response.close();
        }
        return getCommentsResponse;
    }

    public static GetCommentsResponse parseResponse(String json) {
        if (StringUtil.isBlank((String)json)) {
            return new GetCommentsResponse(Collections.emptyList());
        }
        try {
            return new GetCommentsResponse(((Comments)mapper.readValue(json, Comments.class)).getComments());
        }
        catch (IOException e) {
            throw new AtlassianDataStoreException("Failed to parse comments from: \"" + json + "\"", e);
        }
    }

    @Override
    public String getURL() {
        return this.appHome + "/rest/api/latest/issue/" + this.issueIdOrKey + "/comment";
    }

    @Override
    public Map<String, String> getQueryParamMap() {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.startAt != null) {
            queryParams.put("startAt", this.startAt.toString());
        }
        if (this.maxResults != null) {
            queryParams.put("maxResults", this.maxResults.toString());
        }
        if (this.orderBy != null) {
            queryParams.put("orderBy", this.orderBy);
        }
        if (this.expand != null) {
            queryParams.put("expand", String.join((CharSequence)",", this.expand));
        }
        return queryParams;
    }

    public String toString() {
        return "GetCommentsRequest [issueIdOrKey=" + this.issueIdOrKey + ", startAt=" + this.startAt + ", maxResults=" + this.maxResults + ", orderBy=" + this.orderBy + ", expand=" + Arrays.toString(this.expand) + "]";
    }
}

