/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.atlassian.api.jira.issue;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.curl.CurlException;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fess.ds.atlassian.AtlassianDataStoreException;
import org.codelibs.fess.ds.atlassian.api.AtlassianRequest;
import org.codelibs.fess.ds.atlassian.api.jira.domain.Issue;
import org.codelibs.fess.ds.atlassian.api.jira.issue.GetIssueResponse;

public class GetIssueRequest
extends AtlassianRequest {
    private final String issueIdOrKey;
    private String[] fields;
    private String[] expand;
    private String[] properties;

    public GetIssueRequest(String issueIdOrKey) {
        this.issueIdOrKey = issueIdOrKey;
    }

    public GetIssueRequest fields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public GetIssueRequest expand(String ... expand) {
        this.expand = expand;
        return this;
    }

    public GetIssueRequest properties(String ... properties) {
        this.properties = properties;
        return this;
    }

    public GetIssueResponse execute() {
        GetIssueResponse getIssueResponse;
        block9: {
            CurlResponse response = this.getCurlResponse("GET");
            try {
                if (response.getHttpStatusCode() != 200) {
                    throw new CurlException("HTTP Status : " + response.getHttpStatusCode() + ", error : " + response.getContentAsString());
                }
                getIssueResponse = GetIssueRequest.parseResponse(response.getContentAsString());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AtlassianDataStoreException("Failed to access " + this, e);
                }
            }
            response.close();
        }
        return getIssueResponse;
    }

    public static GetIssueResponse parseResponse(String json) {
        if (StringUtil.isBlank((String)json)) {
            return new GetIssueResponse(null);
        }
        try {
            return new GetIssueResponse((Issue)mapper.readValue(json, (TypeReference)new TypeReference<Issue>(){}));
        }
        catch (IOException e) {
            throw new AtlassianDataStoreException("Failed to parse issue from: \"" + json + "\"", e);
        }
    }

    @Override
    public String getURL() {
        return this.appHome + "/rest/api/latest/issue/" + this.issueIdOrKey;
    }

    @Override
    public Map<String, String> getQueryParamMap() {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.fields != null) {
            queryParams.put("fields", String.join((CharSequence)",", this.fields));
        }
        if (this.expand != null) {
            queryParams.put("expand", String.join((CharSequence)",", this.expand));
        }
        if (this.properties != null) {
            queryParams.put("properties", String.join((CharSequence)",", this.properties));
        }
        return queryParams;
    }
}

