/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.atlassian.api.jira.project;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.curl.CurlException;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fess.ds.atlassian.AtlassianDataStoreException;
import org.codelibs.fess.ds.atlassian.api.AtlassianRequest;
import org.codelibs.fess.ds.atlassian.api.jira.domain.Project;
import org.codelibs.fess.ds.atlassian.api.jira.project.GetProjectResponse;

public class GetProjectRequest
extends AtlassianRequest {
    private final String projectIdOrKey;
    private String[] expand;

    public GetProjectRequest(String projectIdOrKey) {
        this.projectIdOrKey = projectIdOrKey;
    }

    public GetProjectRequest expand(String ... expand) {
        this.expand = expand;
        return this;
    }

    public GetProjectResponse execute() {
        GetProjectResponse getProjectResponse;
        block9: {
            CurlResponse response = this.getCurlResponse("GET");
            try {
                if (response.getHttpStatusCode() != 200) {
                    throw new CurlException("HTTP Status : " + response.getHttpStatusCode() + ", error : " + response.getContentAsString());
                }
                getProjectResponse = GetProjectRequest.parseResponse(response.getContentAsString());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AtlassianDataStoreException("Failed to access " + this, e);
                }
            }
            response.close();
        }
        return getProjectResponse;
    }

    public static GetProjectResponse parseResponse(String json) {
        if (StringUtil.isBlank((String)json)) {
            return new GetProjectResponse(null);
        }
        try {
            return new GetProjectResponse((Project)mapper.readValue(json, Project.class));
        }
        catch (IOException e) {
            throw new AtlassianDataStoreException("Failed to parse project from: \"" + json + "\"", e);
        }
    }

    @Override
    public String getURL() {
        return this.appHome + "/rest/api/latest/project/" + this.projectIdOrKey;
    }

    @Override
    public Map<String, String> getQueryParamMap() {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.expand != null) {
            queryParams.put("expand", String.join((CharSequence)",", this.expand));
        }
        return queryParams;
    }
}

