/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.atlassian.api.jira.project;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.curl.CurlException;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fess.ds.atlassian.AtlassianDataStoreException;
import org.codelibs.fess.ds.atlassian.api.AtlassianRequest;
import org.codelibs.fess.ds.atlassian.api.jira.domain.Project;
import org.codelibs.fess.ds.atlassian.api.jira.project.GetProjectsResponse;

public class GetProjectsRequest
extends AtlassianRequest {
    private String[] expand;
    private Integer recent;

    public GetProjectsRequest expand(String ... expand) {
        this.expand = expand;
        return this;
    }

    public GetProjectsRequest recent(int recent) {
        this.recent = recent;
        return this;
    }

    public GetProjectsResponse execute() {
        GetProjectsResponse getProjectsResponse;
        block9: {
            CurlResponse response = this.getCurlResponse("GET");
            try {
                if (response.getHttpStatusCode() != 200) {
                    throw new CurlException("HTTP Status : " + response.getHttpStatusCode() + ", error : " + response.getContentAsString());
                }
                getProjectsResponse = GetProjectsRequest.parseResponse(response.getContentAsString());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AtlassianDataStoreException("Failed to access " + this, e);
                }
            }
            response.close();
        }
        return getProjectsResponse;
    }

    public static GetProjectsResponse parseResponse(String json) {
        if (StringUtil.isBlank((String)json)) {
            return new GetProjectsResponse(Collections.emptyList());
        }
        try {
            return new GetProjectsResponse((List)mapper.readValue(json, (TypeReference)new TypeReference<List<Project>>(){}));
        }
        catch (IOException e) {
            throw new AtlassianDataStoreException("Failed to parse projects from: \"" + json + "\"", e);
        }
    }

    @Override
    public String getURL() {
        return this.appHome() + "/rest/api/latest/project";
    }

    @Override
    public Map<String, String> getQueryParamMap() {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.expand != null) {
            queryParams.put("expand", String.join((CharSequence)",", this.expand));
        }
        if (this.recent != null) {
            queryParams.put("recent", this.recent.toString());
        }
        return queryParams;
    }
}

