/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.atlassian.api.jira.search;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.curl.CurlException;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fess.ds.atlassian.AtlassianDataStoreException;
import org.codelibs.fess.ds.atlassian.api.AtlassianRequest;
import org.codelibs.fess.ds.atlassian.api.jira.search.SearchResponse;

public class SearchRequest
extends AtlassianRequest {
    private String jql;
    private Integer startAt;
    private Integer maxResults;
    private Boolean validateQuery;
    private String[] fields;
    private String[] expand;

    public SearchRequest jql(String jql) {
        this.jql = jql;
        return this;
    }

    public SearchRequest startAt(int startAt) {
        this.startAt = startAt;
        return this;
    }

    public SearchRequest maxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public SearchRequest validateQuery(boolean validateQuery) {
        this.validateQuery = validateQuery;
        return this;
    }

    public SearchRequest fields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public SearchRequest expand(String ... expand) {
        this.expand = expand;
        return this;
    }

    public static SearchResponse parseResponse(String json) {
        if (StringUtil.isBlank((String)json)) {
            return SearchResponse.create(Collections.emptyList());
        }
        try {
            return (SearchResponse)mapper.readValue(json, SearchResponse.class);
        }
        catch (IOException e) {
            throw new AtlassianDataStoreException("Failed to parse: \"" + json + "\"", e);
        }
    }

    public SearchResponse execute() {
        SearchResponse searchResponse;
        block9: {
            CurlResponse response = this.getCurlResponse("GET");
            try {
                if (response.getHttpStatusCode() != 200) {
                    throw new CurlException("HTTP Status : " + response.getHttpStatusCode() + ", error : " + response.getContentAsString());
                }
                searchResponse = SearchRequest.parseResponse(response.getContentAsString());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AtlassianDataStoreException("Failed to access " + this, e);
                }
            }
            response.close();
        }
        return searchResponse;
    }

    @Override
    public String getURL() {
        return this.appHome + "/rest/api/latest/search";
    }

    @Override
    public Map<String, String> getQueryParamMap() {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.jql != null && !this.jql.isEmpty()) {
            queryParams.put("jql", this.jql);
        }
        if (this.startAt != null) {
            queryParams.put("startAt", this.startAt.toString());
        }
        if (this.maxResults != null) {
            queryParams.put("maxResults", this.maxResults.toString());
        }
        if (this.validateQuery != null) {
            queryParams.put("validateQuery", this.validateQuery.toString());
        }
        if (this.fields != null) {
            queryParams.put("fields", String.join((CharSequence)",", this.fields));
        }
        if (this.expand != null) {
            queryParams.put("expand", String.join((CharSequence)",", this.expand));
        }
        return queryParams;
    }
}

