/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.codelibs.fess.suggest.Suggester;
import org.codelibs.fess.suggest.analysis.SuggestAnalyzer;
import org.codelibs.fess.suggest.converter.ReadingConverter;
import org.codelibs.fess.suggest.exception.SuggesterException;
import org.codelibs.fess.suggest.normalizer.Normalizer;
import org.codelibs.fess.suggest.settings.SuggestSettings;
import org.codelibs.fess.suggest.settings.SuggestSettingsBuilder;
import org.codelibs.fess.suggest.util.SuggestUtil;
import org.opensearch.client.Client;

public class SuggesterBuilder {
    protected SuggestSettings settings;
    protected SuggestSettingsBuilder settingsBuilder;
    protected ReadingConverter readingConverter;
    protected ReadingConverter contentsReadingConverter;
    protected Normalizer normalizer;
    protected SuggestAnalyzer analyzer;
    protected ExecutorService threadPool;
    protected int threadPoolSize = Runtime.getRuntime().availableProcessors();

    public SuggesterBuilder settings(SuggestSettings settings) {
        this.settings = settings;
        this.settingsBuilder = null;
        return this;
    }

    public SuggesterBuilder settings(SuggestSettingsBuilder settingsBuilder) {
        this.settingsBuilder = settingsBuilder;
        this.settings = null;
        return this;
    }

    public SuggesterBuilder readingConverter(ReadingConverter readingConverter) {
        this.readingConverter = readingConverter;
        return this;
    }

    public SuggesterBuilder contentsReadigConverter(ReadingConverter contentsReadigConverter) {
        this.contentsReadingConverter = contentsReadigConverter;
        return this;
    }

    public SuggesterBuilder normalizer(Normalizer normalizer) {
        this.normalizer = normalizer;
        return this;
    }

    public SuggesterBuilder analyzer(SuggestAnalyzer analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public SuggesterBuilder threadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
        return this;
    }

    public SuggesterBuilder threadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
        return this;
    }

    public Suggester build(Client client, String id) {
        if (this.settings == null) {
            if (this.settingsBuilder == null) {
                this.settingsBuilder = SuggestSettings.builder();
            }
            this.settings = this.settingsBuilder.build(client, id);
        }
        this.settings.init();
        if (this.readingConverter == null) {
            this.readingConverter = SuggestUtil.createDefaultReadingConverter(client, this.settings);
        }
        try {
            this.readingConverter.init();
        }
        catch (IOException e) {
            throw new SuggesterException(e);
        }
        if (this.contentsReadingConverter == null) {
            this.contentsReadingConverter = SuggestUtil.createDefaultContentsReadingConverter(client, this.settings);
        }
        try {
            this.contentsReadingConverter.init();
        }
        catch (IOException e) {
            throw new SuggesterException(e);
        }
        if (this.normalizer == null) {
            this.normalizer = SuggestUtil.createDefaultNormalizer(client, this.settings);
        }
        if (this.analyzer == null) {
            this.analyzer = SuggestUtil.createDefaultAnalyzer(client, this.settings);
        }
        if (this.threadPool == null) {
            this.threadPool = Executors.newFixedThreadPool(this.threadPoolSize);
        }
        return new Suggester(client, this.settings, this.readingConverter, this.contentsReadingConverter, this.normalizer, this.analyzer, this.threadPool);
    }
}

