/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.concurrent;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.codelibs.core.exception.InterruptedRuntimeException;
import org.codelibs.fess.suggest.exception.SuggesterException;
import org.codelibs.fess.suggest.request.Response;

public class Deferred<RESPONSE extends Response> {
    private RESPONSE response = null;
    private Throwable error = null;
    private final Promise promise = new Promise();
    private final Queue<Consumer<RESPONSE>> doneCallbacks = new LinkedBlockingQueue<Consumer<RESPONSE>>();
    private final Queue<Consumer<Throwable>> errorCallbacks = new LinkedBlockingQueue<Consumer<Throwable>>();
    private final CountDownLatch latch = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(RESPONSE r) {
        ArrayList<Consumer<RESPONSE>> executeCallbacks;
        Deferred deferred = this;
        synchronized (deferred) {
            Consumer<RESPONSE> callback2;
            if (this.response != null || this.error != null) {
                return;
            }
            this.response = r;
            executeCallbacks = new ArrayList<Consumer<RESPONSE>>(this.doneCallbacks.size());
            while ((callback2 = this.doneCallbacks.poll()) != null) {
                executeCallbacks.add(callback2);
            }
        }
        if (executeCallbacks.size() > 0) {
            try {
                executeCallbacks.stream().forEach(callback -> callback.accept(this.response));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.latch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reject(Throwable t) {
        ArrayList<Consumer<Throwable>> executeCallbacks;
        Deferred deferred = this;
        synchronized (deferred) {
            Consumer<Throwable> callback2;
            if (this.response != null || this.error != null) {
                return;
            }
            this.error = t;
            executeCallbacks = new ArrayList<Consumer<Throwable>>(this.errorCallbacks.size());
            while ((callback2 = this.errorCallbacks.poll()) != null) {
                executeCallbacks.add(callback2);
            }
        }
        if (executeCallbacks.size() > 0) {
            try {
                executeCallbacks.stream().forEach(callback -> callback.accept(this.error));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.latch.countDown();
    }

    public Promise then(Consumer<RESPONSE> consumer) {
        return this.promise.then(consumer);
    }

    public Promise error(Consumer<Throwable> consumer) {
        return this.promise.error(consumer);
    }

    public Promise promise() {
        return this.promise;
    }

    public class Promise {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Promise then(Consumer<RESPONSE> consumer) {
            ArrayList executeCallbacks;
            Deferred deferred = Deferred.this;
            synchronized (deferred) {
                Deferred.this.doneCallbacks.add(consumer);
                executeCallbacks = new ArrayList(Deferred.this.doneCallbacks.size());
                if (Deferred.this.response != null) {
                    Consumer callback2;
                    while ((callback2 = Deferred.this.doneCallbacks.poll()) != null) {
                        executeCallbacks.add(callback2);
                    }
                }
            }
            if (executeCallbacks.size() > 0) {
                executeCallbacks.stream().forEach(callback -> callback.accept(Deferred.this.response));
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Promise error(Consumer<Throwable> consumer) {
            ArrayList<Consumer<Throwable>> executeCallbacks;
            Deferred deferred = Deferred.this;
            synchronized (deferred) {
                Deferred.this.errorCallbacks.add(consumer);
                executeCallbacks = new ArrayList<Consumer<Throwable>>(Deferred.this.errorCallbacks.size());
                if (Deferred.this.error != null) {
                    Consumer<Throwable> callback2;
                    while ((callback2 = Deferred.this.errorCallbacks.poll()) != null) {
                        executeCallbacks.add(callback2);
                    }
                }
            }
            if (executeCallbacks.size() > 0) {
                executeCallbacks.stream().forEach(callback -> callback.accept(Deferred.this.error));
            }
            return this;
        }

        public RESPONSE getResponse() {
            return this.getResponse(1L, TimeUnit.MINUTES);
        }

        public RESPONSE getResponse(long time, TimeUnit unit) {
            try {
                boolean isTimeout;
                boolean bl = isTimeout = !Deferred.this.latch.await(time, unit);
                if (isTimeout) {
                    throw new SuggesterException("Request timeout. time:" + time + " unit:" + unit.name());
                }
                if (Deferred.this.error != null) {
                    throw new SuggesterException(Deferred.this.error);
                }
                return Deferred.this.response;
            }
            catch (InterruptedException e) {
                throw new InterruptedRuntimeException(e);
            }
        }
    }
}

