/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.converter;

import com.ibm.icu.text.Transliterator;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.codelibs.fess.suggest.converter.ReadingConverter;
import org.opensearch.core.common.Strings;

public class KatakanaConverter
implements ReadingConverter {
    protected final Transliterator transliterator = Transliterator.getInstance((String)"Hiragana-Katakana");
    protected volatile boolean initialized = false;
    protected TokenizerFactory tokenizerFactory = null;

    public KatakanaConverter() {
    }

    public KatakanaConverter(TokenizerFactory tokenizerFactory) {
        if (this.isEnableTokenizer(tokenizerFactory)) {
            this.tokenizerFactory = tokenizerFactory;
        }
    }

    @Override
    public void init() throws IOException {
    }

    @Override
    public List<String> convert(String text, String field, String ... langs) throws IOException {
        ArrayList<String> readingList = new ArrayList<String>();
        readingList.add(this.toKatakana(text));
        return readingList;
    }

    protected String toKatakana(String inputStr) throws IOException {
        StringBuilder kanaBuf = new StringBuilder();
        StringReader rd = new StringReader(inputStr);
        try (TokenStream stream = this.createTokenStream(rd);){
            if (stream == null) {
                throw new IOException("Invalid tokenizer.");
            }
            stream.reset();
            int offset = 0;
            while (stream.incrementToken()) {
                CharTermAttribute att = (CharTermAttribute)stream.getAttribute(CharTermAttribute.class);
                String term = att.toString();
                int pos = inputStr.indexOf(term, offset);
                if (pos > 0) {
                    String tmp = inputStr.substring(offset, pos);
                    kanaBuf.append(this.transliterator.transliterate(tmp));
                    offset = pos;
                } else if (pos == -1) continue;
                String reading = this.getReadingFromAttribute(stream);
                if (Strings.isNullOrEmpty((String)reading)) {
                    reading = this.transliterator.transliterate(att.toString());
                }
                kanaBuf.append(reading);
                offset += term.length();
            }
        }
        return kanaBuf.toString();
    }

    protected boolean isEnableTokenizer(TokenizerFactory factory) {
        return false;
    }

    private TokenStream createTokenStream(Reader rd) {
        return null;
    }

    protected String getReadingFromAttribute(TokenStream stream) {
        return null;
    }
}

