/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.converter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.codelibs.fess.suggest.converter.ReadingConverter;

public class ReadingConverterChain
implements ReadingConverter {
    private final List<ReadingConverter> converters = new ArrayList<ReadingConverter>();

    @Override
    public void init() throws IOException {
        for (ReadingConverter converter : this.converters) {
            converter.init();
        }
    }

    @Override
    public List<String> convert(String text, String field, String ... lang) throws IOException {
        LinkedList<String> queue = new LinkedList<String>();
        queue.add(text);
        ArrayList<String> convertedTexts = new ArrayList<String>(this.getMaxReadingNum());
        convertedTexts.add(text);
        for (ReadingConverter converter : this.converters) {
            String s;
            while ((s = (String)queue.poll()) != null && convertedTexts.size() <= this.getMaxReadingNum()) {
                List<String> results = converter.convert(s, field, lang);
                convertedTexts.addAll(results);
            }
            queue.addAll(convertedTexts);
        }
        return convertedTexts;
    }

    public void addConverter(ReadingConverter converter) {
        this.converters.add(converter);
    }
}

