/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.index;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.lang.ThreadUtil;
import org.codelibs.fess.suggest.analysis.SuggestAnalyzer;
import org.codelibs.fess.suggest.concurrent.Deferred;
import org.codelibs.fess.suggest.converter.ReadingConverter;
import org.codelibs.fess.suggest.entity.ElevateWord;
import org.codelibs.fess.suggest.entity.SuggestItem;
import org.codelibs.fess.suggest.exception.SuggestIndexException;
import org.codelibs.fess.suggest.index.SuggestDeleteResponse;
import org.codelibs.fess.suggest.index.SuggestIndexResponse;
import org.codelibs.fess.suggest.index.contents.ContentsParser;
import org.codelibs.fess.suggest.index.contents.DefaultContentsParser;
import org.codelibs.fess.suggest.index.contents.document.DocumentReader;
import org.codelibs.fess.suggest.index.contents.querylog.QueryLog;
import org.codelibs.fess.suggest.index.contents.querylog.QueryLogReader;
import org.codelibs.fess.suggest.index.writer.SuggestIndexWriter;
import org.codelibs.fess.suggest.index.writer.SuggestWriter;
import org.codelibs.fess.suggest.index.writer.SuggestWriterResult;
import org.codelibs.fess.suggest.normalizer.Normalizer;
import org.codelibs.fess.suggest.settings.SuggestSettings;
import org.codelibs.fess.suggest.util.SuggestUtil;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;

public class SuggestIndexer {
    private static final Logger logger = LogManager.getLogger(SuggestIndexer.class);
    protected final Client client;
    protected String index;
    protected SuggestSettings settings;
    protected String[] supportedFields;
    protected String[] tagFieldNames;
    protected String roleFieldName;
    protected String langFieldName;
    protected String[] badWords;
    protected boolean parallel;
    protected ReadingConverter readingConverter;
    protected ReadingConverter contentsReadingConverter;
    protected Normalizer normalizer;
    protected SuggestAnalyzer analyzer;
    protected ContentsParser contentsParser;
    protected SuggestWriter suggestWriter;
    protected ExecutorService threadPool;

    public SuggestIndexer(Client client, String index, ReadingConverter readingConverter, ReadingConverter contentsReadingConverter, Normalizer normalizer, SuggestAnalyzer analyzer, SuggestSettings settings, ExecutorService threadPool) {
        this.client = client;
        this.index = index;
        this.supportedFields = settings.array().get("supportedFields");
        this.badWords = settings.badword().get(true);
        this.tagFieldNames = settings.getAsString("tagFieldName", "").split(",");
        this.roleFieldName = settings.getAsString("roleFieldName", "");
        this.langFieldName = settings.getAsString("langFieldName", "");
        this.parallel = settings.getAsBoolean("parallel", false);
        this.readingConverter = readingConverter;
        this.contentsReadingConverter = contentsReadingConverter;
        this.normalizer = normalizer;
        this.analyzer = analyzer;
        this.settings = settings;
        this.contentsParser = new DefaultContentsParser();
        this.suggestWriter = new SuggestIndexWriter();
        this.threadPool = threadPool;
    }

    public SuggestIndexResponse index(SuggestItem item) {
        return this.index(new SuggestItem[]{item});
    }

    public SuggestIndexResponse index(SuggestItem[] items) {
        SuggestItem[] array = (SuggestItem[])Stream.of(items).filter(item -> !item.isBadWord(this.badWords)).toArray(SuggestItem[]::new);
        try {
            long start = System.currentTimeMillis();
            SuggestWriterResult result = this.suggestWriter.write(this.client, this.settings, this.index, array, true);
            return new SuggestIndexResponse(items.length, items.length, result.getFailures(), System.currentTimeMillis() - start);
        }
        catch (Exception e) {
            throw new SuggestIndexException("Failed to write items[" + items.length + "] to " + this.index, e);
        }
    }

    public SuggestDeleteResponse delete(String id) {
        long start = System.currentTimeMillis();
        SuggestWriterResult result = this.suggestWriter.delete(this.client, this.settings, this.index, id);
        return new SuggestDeleteResponse(result.getFailures(), System.currentTimeMillis() - start);
    }

    public SuggestDeleteResponse deleteByQuery(String queryString) {
        return this.deleteByQuery((QueryBuilder)QueryBuilders.queryStringQuery((String)queryString).defaultOperator(Operator.AND));
    }

    public SuggestDeleteResponse deleteByQuery(QueryBuilder queryBuilder) {
        long start = System.currentTimeMillis();
        SuggestWriterResult result = this.suggestWriter.deleteByQuery(this.client, this.settings, this.index, queryBuilder);
        return new SuggestDeleteResponse(result.getFailures(), System.currentTimeMillis() - start);
    }

    public SuggestDeleteResponse deleteAll() {
        SuggestDeleteResponse response = this.deleteByQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        this.restoreElevateWord();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SuggestDeleteResponse deleteDocumentWords() {
        long start = System.currentTimeMillis();
        SuggestDeleteResponse deleteResponse = this.deleteByQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)"docFreq").gte((Object)1)).mustNot((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"kinds", (Object)SuggestItem.Kind.QUERY.toString())).mustNot((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"kinds", (Object)SuggestItem.Kind.USER.toString())));
        if (deleteResponse.hasError()) {
            throw new SuggestIndexException(deleteResponse.getErrors().get(0));
        }
        ArrayList<SuggestItem> updateItems = new ArrayList<SuggestItem>();
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.index}).setSize(500).setScroll(this.settings.getScrollTimeout()).setQuery((QueryBuilder)QueryBuilders.rangeQuery((String)"docFreq").gte((Object)1)).execute().actionGet(this.settings.getSearchTimeout());
        String scrollId = response.getScrollId();
        try {
            while (scrollId != null) {
                SearchHit[] hits = response.getHits().getHits();
                if (hits.length == 0) {
                    break;
                }
                for (SearchHit hit : hits) {
                    SuggestItem item = SuggestItem.parseSource(hit.getSourceAsMap());
                    item.setDocFreq(0L);
                    item.setKinds((SuggestItem.Kind[])Stream.of(item.getKinds()).filter(kind -> kind != SuggestItem.Kind.DOCUMENT).toArray(SuggestItem.Kind[]::new));
                    updateItems.add(item);
                }
                SuggestWriterResult result = this.suggestWriter.write(this.client, this.settings, this.index, updateItems.toArray(new SuggestItem[updateItems.size()]), false);
                if (result.hasFailure()) {
                    throw new SuggestIndexException(result.getFailures().get(0));
                }
                response = (SearchResponse)this.client.prepareSearchScroll(scrollId).execute().actionGet(this.settings.getSearchTimeout());
                if (!scrollId.equals(response.getScrollId())) {
                    SuggestUtil.deleteScrollContext(this.client, scrollId);
                }
                scrollId = response.getScrollId();
            }
        }
        finally {
            SuggestUtil.deleteScrollContext(this.client, scrollId);
        }
        return new SuggestDeleteResponse(null, System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SuggestDeleteResponse deleteQueryWords() {
        long start = System.currentTimeMillis();
        SuggestDeleteResponse deleteResponse = this.deleteByQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)"queryFreq").gte((Object)1)).mustNot((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"kinds", (Object)SuggestItem.Kind.DOCUMENT.toString())).mustNot((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"kinds", (Object)SuggestItem.Kind.USER.toString())));
        if (deleteResponse.hasError()) {
            throw new SuggestIndexException(deleteResponse.getErrors().get(0));
        }
        ArrayList<SuggestItem> updateItems = new ArrayList<SuggestItem>();
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.index}).setSize(500).setScroll(this.settings.getScrollTimeout()).setQuery((QueryBuilder)QueryBuilders.rangeQuery((String)"queryFreq").gte((Object)1)).execute().actionGet(this.settings.getSearchTimeout());
        String scrollId = response.getScrollId();
        try {
            while (scrollId != null) {
                SearchHit[] hits = response.getHits().getHits();
                if (hits.length == 0) {
                    break;
                }
                for (SearchHit hit : hits) {
                    SuggestItem item = SuggestItem.parseSource(hit.getSourceAsMap());
                    item.setQueryFreq(0L);
                    item.setKinds((SuggestItem.Kind[])Stream.of(item.getKinds()).filter(kind -> kind != SuggestItem.Kind.QUERY).toArray(SuggestItem.Kind[]::new));
                    updateItems.add(item);
                }
                SuggestWriterResult result = this.suggestWriter.write(this.client, this.settings, this.index, updateItems.toArray(new SuggestItem[updateItems.size()]), false);
                if (result.hasFailure()) {
                    throw new SuggestIndexException(result.getFailures().get(0));
                }
                response = (SearchResponse)this.client.prepareSearchScroll(scrollId).execute().actionGet(this.settings.getSearchTimeout());
                if (!scrollId.equals(response.getScrollId())) {
                    SuggestUtil.deleteScrollContext(this.client, scrollId);
                }
                scrollId = response.getScrollId();
            }
        }
        finally {
            SuggestUtil.deleteScrollContext(this.client, scrollId);
        }
        return new SuggestDeleteResponse(null, System.currentTimeMillis() - start);
    }

    public SuggestIndexResponse indexFromQueryLog(QueryLog queryLog) {
        return this.indexFromQueryLog(new QueryLog[]{queryLog});
    }

    public SuggestIndexResponse indexFromQueryLog(QueryLog[] queryLogs) {
        if (logger.isInfoEnabled()) {
            logger.info("Index from querylog. num: {}", (Object)queryLogs.length);
        }
        try {
            long start = System.currentTimeMillis();
            Stream<QueryLog> stream = Stream.of(queryLogs);
            if (this.parallel) {
                stream.parallel();
            }
            SuggestItem[] array = (SuggestItem[])stream.flatMap(queryLog -> this.contentsParser.parseQueryLog((QueryLog)queryLog, this.supportedFields, this.tagFieldNames, this.roleFieldName, this.readingConverter, this.normalizer).stream()).toArray(SuggestItem[]::new);
            long parseTime = System.currentTimeMillis();
            SuggestIndexResponse response = this.index(array);
            long indexTime = System.currentTimeMillis();
            if (logger.isInfoEnabled()) {
                this.printProcessingInfo("queries", queryLogs.length, array, parseTime - start, indexTime - parseTime);
            }
            return new SuggestIndexResponse(array.length, queryLogs.length, response.getErrors(), System.currentTimeMillis() - start);
        }
        catch (Exception e) {
            throw new SuggestIndexException("Failed to index from query_string.", e);
        }
    }

    public Deferred.Promise indexFromQueryLog(QueryLogReader queryLogReader, int docPerReq, long requestInterval) {
        Deferred deferred = new Deferred();
        this.threadPool.execute(() -> {
            long start = System.currentTimeMillis();
            int numberOfSuggestDocs = 0;
            int numberOfInputDocs = 0;
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            ArrayList<QueryLog> queryLogs = new ArrayList<QueryLog>(docPerReq);
            try {
                QueryLog queryLog = queryLogReader.read();
                while (queryLog != null && !Thread.currentThread().isInterrupted()) {
                    queryLogs.add(queryLog);
                    queryLog = queryLogReader.read();
                    if ((queryLog != null || queryLogs.isEmpty()) && queryLogs.size() < docPerReq) continue;
                    SuggestIndexResponse res = this.indexFromQueryLog(queryLogs.toArray(new QueryLog[queryLogs.size()]));
                    errors.addAll(res.getErrors());
                    numberOfSuggestDocs += res.getNumberOfSuggestDocs();
                    numberOfInputDocs += res.getNumberOfInputDocs();
                    queryLogs.clear();
                    Thread.sleep(requestInterval);
                }
                deferred.resolve(new SuggestIndexResponse(numberOfSuggestDocs, numberOfInputDocs, errors, System.currentTimeMillis() - start));
            }
            catch (Throwable t) {
                deferred.reject(t);
            }
            finally {
                queryLogReader.close();
            }
        });
        return deferred.promise();
    }

    public SuggestIndexResponse indexFromDocument(Map<String, Object>[] documents) {
        long start = System.currentTimeMillis();
        try {
            Stream<Map<String, Object>> stream = Stream.of(documents);
            if (this.parallel) {
                stream.parallel();
            }
            SuggestItem[] items = (SuggestItem[])stream.flatMap(document -> {
                try {
                    return this.contentsParser.parseDocument((Map<String, Object>)document, this.supportedFields, this.tagFieldNames, this.roleFieldName, this.langFieldName, this.readingConverter, this.contentsReadingConverter, this.normalizer, this.analyzer).stream();
                }
                catch (IllegalStateException | OpenSearchStatusException e) {
                    String msg = e.getMessage();
                    if (StringUtil.isNotEmpty((String)msg) || msg.contains("index.analyze.max_token_count")) {
                        logger.warn("Failed to parse document. ", e);
                        return Stream.empty();
                    }
                    throw e;
                }
            }).toArray(SuggestItem[]::new);
            long parseTime = System.currentTimeMillis();
            SuggestIndexResponse response = this.index(items);
            long indexTime = System.currentTimeMillis();
            if (logger.isInfoEnabled()) {
                this.printProcessingInfo("documents", documents.length, items, parseTime - start, indexTime - parseTime);
            }
            return new SuggestIndexResponse(items.length, documents.length, response.getErrors(), indexTime - start);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to index from document", (Throwable)e);
            }
            throw new SuggestIndexException("Failed to index from document", e);
        }
    }

    private void printProcessingInfo(String type, int size, SuggestItem[] items, long parseTime, long indexTime) {
        double cpuLoad;
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystemMXBean instanceof com.sun.management.OperatingSystemMXBean) {
            com.sun.management.OperatingSystemMXBean operatingSystemMXBean2 = (com.sun.management.OperatingSystemMXBean)operatingSystemMXBean;
            cpuLoad = operatingSystemMXBean2.getProcessCpuLoad();
        } else {
            cpuLoad = -1.0;
        }
        long maxMemory = Runtime.getRuntime().maxMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        String msg = String.format("%d words from %d %s: {\"time\":{\"parse\":%d,\"index\":%d},\"cpu\":%f,\"mem\":{\"heap\":\"%dmb\",\"used\":\"%dmb\"}}", items.length, size, type, parseTime, indexTime, cpuLoad, maxMemory / 0x100000L, (maxMemory - freeMemory) / 0x100000L);
        logger.info(msg);
        if (logger.isDebugEnabled()) {
            for (SuggestItem item : items) {
                logger.debug("[{}] {}", (Object)type, (Object)item.toJsonString());
            }
        }
    }

    @Deprecated
    public Deferred.Promise indexFromDocument(Supplier<DocumentReader> reader, int docPerReq, long requestInterval) {
        return this.indexFromDocument(reader, docPerReq, () -> ThreadUtil.sleep((long)requestInterval));
    }

    public Deferred.Promise indexFromDocument(Supplier<DocumentReader> reader, int docPerReq, Runnable waitController) {
        if (logger.isInfoEnabled()) {
            logger.info("Start index by DocumentReader. docPerReq: {}", (Object)docPerReq);
        }
        Deferred deferred = new Deferred();
        this.threadPool.execute(() -> {
            long start = System.currentTimeMillis();
            int numberOfSuggestDocs = 0;
            int numberOfInputDocs = 0;
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            ArrayList<Map<String, Object>> docs = new ArrayList<Map<String, Object>>(docPerReq);
            try (DocumentReader documentReader = (DocumentReader)reader.get();){
                Map<String, Object> doc = documentReader.read();
                while (doc != null && !Thread.currentThread().isInterrupted()) {
                    docs.add(doc);
                    doc = documentReader.read();
                    if (doc != null && docs.size() < docPerReq) continue;
                    SuggestIndexResponse res = this.indexFromDocument(docs.toArray(new Map[docs.size()]));
                    errors.addAll(res.getErrors());
                    numberOfSuggestDocs += res.getNumberOfSuggestDocs();
                    numberOfInputDocs += res.getNumberOfInputDocs();
                    this.client.admin().indices().prepareRefresh(new String[]{this.index}).execute().actionGet(this.settings.getIndicesTimeout());
                    docs.clear();
                    waitController.run();
                }
                deferred.resolve(new SuggestIndexResponse(numberOfSuggestDocs, numberOfInputDocs, errors, System.currentTimeMillis() - start));
            }
            catch (Throwable t) {
                deferred.reject(t);
            }
        });
        return deferred.promise();
    }

    public SuggestIndexResponse indexFromSearchWord(String searchWord, String[] fields, String[] tags, String[] roles, int num, String[] langs) {
        if (logger.isDebugEnabled()) {
            logger.debug("Index from searchWord. word: {}", (Object)searchWord);
        }
        long start = System.currentTimeMillis();
        StringBuilder buf = new StringBuilder(searchWord.length());
        char prev = '\u0000';
        for (char c : searchWord.toCharArray()) {
            if (!Character.isWhitespace(c)) {
                buf.append(c);
            } else if (!Character.isWhitespace(prev)) {
                buf.append(' ');
            }
            prev = c;
        }
        String[] words = buf.toString().trim().split(" ");
        try {
            SuggestItem item = this.contentsParser.parseSearchWords(words, null, fields, tags, roles, num, this.readingConverter, this.normalizer, this.analyzer, langs);
            if (item == null) {
                return new SuggestIndexResponse(0, 1, null, System.currentTimeMillis() - start);
            }
            long parseTime = System.currentTimeMillis();
            SuggestIndexResponse response = this.index(item);
            long indexTime = System.currentTimeMillis();
            if (logger.isInfoEnabled()) {
                this.printProcessingInfo("queries", 1, new SuggestItem[]{item}, parseTime - start, indexTime - parseTime);
            }
            return new SuggestIndexResponse(1, 1, response.getErrors(), System.currentTimeMillis() - start);
        }
        catch (Exception e) {
            String msg = "Failed to index from document: searchWord=" + searchWord + ", fields=" + Arrays.toString(fields) + ", tags=" + Arrays.toString(tags) + ", roles=" + Arrays.toString(roles) + ", langs=" + Arrays.toString(langs) + ", num=" + num;
            if (logger.isDebugEnabled()) {
                logger.debug(msg, (Throwable)e);
            }
            throw new SuggestIndexException(msg, e);
        }
    }

    public SuggestDeleteResponse addBadWord(String badWord, boolean apply) {
        String normalized = this.normalizer.normalize(badWord, "", new String[0]);
        this.settings.badword().add(normalized);
        this.badWords = this.settings.badword().get(true);
        if (apply) {
            return this.deleteByQuery((QueryBuilder)QueryBuilders.wildcardQuery((String)"text", (String)("*" + normalized + "*")));
        }
        return new SuggestDeleteResponse(null, 0L);
    }

    public void deleteBadWord(String badWord) {
        this.settings.badword().delete(this.normalizer.normalize(badWord, "", new String[0]));
    }

    public SuggestIndexResponse addElevateWord(ElevateWord elevateWord, boolean apply) {
        String normalizedWord = this.normalizer.normalize(elevateWord.getElevateWord(), "", new String[0]);
        List<String> normalizedReadings = elevateWord.getReadings().stream().map(reading -> this.normalizer.normalize((String)reading, "", new String[0])).collect(Collectors.toList());
        ElevateWord normalized = new ElevateWord(normalizedWord, elevateWord.getBoost(), normalizedReadings, elevateWord.getFields(), elevateWord.getTags(), elevateWord.getRoles());
        this.settings.elevateWord().add(normalized);
        if (apply) {
            return this.index(normalized.toSuggestItem());
        }
        return new SuggestIndexResponse(0, 0, null, 0L);
    }

    public SuggestDeleteResponse deleteElevateWord(String elevateWord, boolean apply) {
        String normalized = this.normalizer.normalize(elevateWord, "", new String[0]);
        this.settings.elevateWord().delete(normalized);
        if (apply) {
            return this.delete(SuggestUtil.createSuggestTextId(normalized));
        }
        return new SuggestDeleteResponse(null, 0L);
    }

    public SuggestIndexResponse restoreElevateWord() {
        long start = System.currentTimeMillis();
        int numberOfSuggestDocs = 0;
        int numberOfInputDocs = 0;
        ElevateWord[] elevateWords = this.settings.elevateWord().get();
        ArrayList<Throwable> errors = new ArrayList<Throwable>(elevateWords.length);
        for (ElevateWord elevateWord : elevateWords) {
            SuggestIndexResponse res = this.addElevateWord(elevateWord, true);
            numberOfSuggestDocs += res.getNumberOfSuggestDocs();
            numberOfInputDocs += res.getNumberOfInputDocs();
            errors.addAll(res.getErrors());
        }
        return new SuggestIndexResponse(numberOfSuggestDocs, numberOfInputDocs, errors, System.currentTimeMillis() - start);
    }

    public SuggestDeleteResponse deleteOldWords(ZonedDateTime threshold) {
        long start = System.currentTimeMillis();
        String query = "@timestamp:[* TO " + threshold.toInstant().toEpochMilli() + "] NOT kinds:" + SuggestItem.Kind.USER;
        this.deleteByQuery(query);
        return new SuggestDeleteResponse(null, System.currentTimeMillis() - start);
    }

    public SuggestIndexer setIndexName(String index) {
        this.index = index;
        return this;
    }

    public SuggestIndexer setSupportedFields(String[] supportedFields) {
        this.supportedFields = supportedFields;
        return this;
    }

    public SuggestIndexer setTagFieldNames(String[] tagFieldNames) {
        this.tagFieldNames = tagFieldNames;
        return this;
    }

    public SuggestIndexer setRoleFieldName(String roleFieldName) {
        this.roleFieldName = roleFieldName;
        return this;
    }

    public SuggestIndexer setReadingConverter(ReadingConverter readingConverter) {
        this.readingConverter = readingConverter;
        return this;
    }

    public SuggestIndexer setNormalizer(Normalizer normalizer) {
        this.normalizer = normalizer;
        return this;
    }

    public SuggestIndexer setAnalyzer(SuggestAnalyzer analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public SuggestIndexer setContentsParser(ContentsParser contentsParser) {
        this.contentsParser = contentsParser;
        return this;
    }

    public SuggestIndexer setSuggestWriter(SuggestWriter suggestWriter) {
        this.suggestWriter = suggestWriter;
        return this;
    }
}

