/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.index.contents.document;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codelibs.fess.suggest.index.contents.document.DocumentReader;
import org.codelibs.fess.suggest.settings.SuggestSettings;
import org.codelibs.fess.suggest.util.SuggestUtil;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.sort.SortBuilder;

public class ESSourceReader
implements DocumentReader {
    private static final Logger logger = LogManager.getLogger(ESSourceReader.class);
    protected final Queue<Map<String, Object>> queue = new ConcurrentLinkedQueue<Map<String, Object>>();
    protected final AtomicBoolean isFinished = new AtomicBoolean(false);
    protected final Random random = new Random();
    protected final Client client;
    protected final SuggestSettings settings;
    protected final String indexName;
    protected final String[] supportedFields;
    protected int scrollSize = 1;
    protected int maxRetryCount = 5;
    protected long limitOfDocumentSize = 50000L;
    protected QueryBuilder queryBuilder = QueryBuilders.matchAllQuery();
    protected int limitPercentage = 100;
    protected long limitNumber = -1L;
    protected List<SortBuilder<?>> sortList = new ArrayList();
    protected String scrollId = null;
    protected final AtomicLong docCount = new AtomicLong(0L);
    protected final long totalDocNum;

    public ESSourceReader(Client client, SuggestSettings settings, String indexName) {
        this.client = client;
        this.settings = settings;
        this.indexName = indexName;
        this.supportedFields = settings.array().get("supportedFields");
        this.totalDocNum = this.getTotal();
    }

    @Override
    public synchronized Map<String, Object> read() {
        while (!this.isFinished.get() && this.queue.isEmpty()) {
            this.addDocumentToQueue();
        }
        return this.queue.poll();
    }

    @Override
    public void close() {
        this.isFinished.set(true);
        this.queue.clear();
    }

    public void setScrollSize(int scrollSize) {
        this.scrollSize = scrollSize;
    }

    public void setLimitOfDocumentSize(long limitOfDocumentSize) {
        if (logger.isInfoEnabled()) {
            logger.info("Set document limit: {}", (Object)limitOfDocumentSize);
        }
        this.limitOfDocumentSize = limitOfDocumentSize;
    }

    public void setQuery(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    public void addSort(SortBuilder<?> sortBuilder) {
        this.sortList.add(sortBuilder);
    }

    public void setLimitDocNumPercentage(String limitPercentage) {
        if (logger.isInfoEnabled()) {
            logger.info("Set document limitPercentage: {}", (Object)limitPercentage);
        }
        this.limitPercentage = limitPercentage.endsWith("%") ? Integer.parseInt(limitPercentage.substring(0, limitPercentage.length() - 1)) : Integer.parseInt(limitPercentage);
        if (this.limitPercentage > 100) {
            this.limitPercentage = 100;
        } else if (this.limitPercentage < 1) {
            this.limitPercentage = 1;
        }
    }

    public void setLimitNumber(long limitNumber) {
        this.limitNumber = limitNumber;
    }

    protected void addDocumentToQueue() {
        if (this.docCount.get() > ESSourceReader.getLimitDocNum(this.totalDocNum, this.limitPercentage, this.limitNumber)) {
            this.isFinished.set(true);
            return;
        }
        RuntimeException exception = null;
        for (int i = 0; i < this.maxRetryCount; ++i) {
            try {
                SearchResponse response;
                if (this.scrollId == null) {
                    SearchRequestBuilder builder = this.client.prepareSearch(new String[0]).setIndices(new String[]{this.indexName}).setScroll(this.settings.getScrollTimeout()).setQuery(this.queryBuilder).setSize(this.scrollSize);
                    for (SortBuilder<?> sortBuilder : this.sortList) {
                        builder.addSort(sortBuilder);
                    }
                    response = (SearchResponse)builder.execute().actionGet(this.settings.getSearchTimeout());
                } else {
                    response = (SearchResponse)this.client.prepareSearchScroll(this.scrollId).setScroll(this.settings.getScrollTimeout()).execute().actionGet(this.settings.getSearchTimeout());
                    if (!this.scrollId.equals(response.getScrollId())) {
                        SuggestUtil.deleteScrollContext(this.client, this.scrollId);
                    }
                }
                this.scrollId = response.getScrollId();
                SearchHit[] hits = response.getHits().getHits();
                if (this.scrollId == null || hits.length == 0) {
                    SuggestUtil.deleteScrollContext(this.client, this.scrollId);
                    this.isFinished.set(true);
                }
                for (SearchHit hit : hits) {
                    Map source = hit.getSourceAsMap();
                    if (this.limitOfDocumentSize > 0L) {
                        long size = 0L;
                        for (String field : this.supportedFields) {
                            Object value = source.get(field);
                            if (value == null) continue;
                            size += (long)value.toString().length();
                        }
                        if (size > this.limitOfDocumentSize) continue;
                        this.queue.add(source);
                        continue;
                    }
                    this.queue.add(source);
                }
                exception = null;
                break;
            }
            catch (Exception e) {
                exception = new RuntimeException(e);
                this.scrollId = null;
                continue;
            }
        }
        this.docCount.getAndAdd(this.queue.size());
        if (exception != null) {
            throw exception;
        }
    }

    protected static long getLimitDocNum(long total, long limitPercentage, long limitNumber) {
        long percentNum = (long)((float)total * ((float)limitPercentage / 100.0f));
        if (limitNumber < 0L) {
            return percentNum;
        }
        return percentNum < limitNumber ? percentNum : limitNumber;
    }

    protected long getTotal() {
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[0]).setIndices(new String[]{this.indexName}).setQuery(this.queryBuilder).setSize(0).setTrackTotalHits(true).execute().actionGet(this.settings.getSearchTimeout());
        return response.getHits().getTotalHits().value;
    }
}

