/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.request;

import org.codelibs.fess.suggest.concurrent.Deferred;
import org.codelibs.fess.suggest.exception.SuggesterException;
import org.codelibs.fess.suggest.request.Response;
import org.opensearch.client.Client;
import org.opensearch.core.common.Strings;

public abstract class Request<T extends Response> {
    public Deferred.Promise execute(Client client) {
        String error = this.getValidationError();
        if (!Strings.isNullOrEmpty((String)error)) {
            throw new IllegalArgumentException(error);
        }
        Deferred deferred = new Deferred();
        try {
            this.processRequest(client, deferred);
        }
        catch (Exception e) {
            throw new SuggesterException(e);
        }
        return deferred.promise();
    }

    protected abstract void processRequest(Client var1, Deferred<T> var2);

    protected abstract String getValidationError();
}

