/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.request.suggest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codelibs.fess.suggest.concurrent.Deferred;
import org.codelibs.fess.suggest.converter.ReadingConverter;
import org.codelibs.fess.suggest.entity.SuggestItem;
import org.codelibs.fess.suggest.exception.SuggesterException;
import org.codelibs.fess.suggest.normalizer.Normalizer;
import org.codelibs.fess.suggest.request.Request;
import org.codelibs.fess.suggest.request.suggest.SuggestResponse;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.common.lucene.search.function.CombineFunction;
import org.opensearch.common.lucene.search.function.FieldValueFactorFunction;
import org.opensearch.common.lucene.search.function.FunctionScoreQuery;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.sort.SortOrder;

public class SuggestRequest
extends Request<SuggestResponse> {
    private String index = null;
    private String query = "";
    private int size = 10;
    private final List<String> tags = new ArrayList<String>();
    private final List<String> roles = new ArrayList<String>();
    private final List<String> fields = new ArrayList<String>();
    private final List<String> kinds = new ArrayList<String>();
    private final List<String> languages = new ArrayList<String>();
    private boolean suggestDetail = true;
    private ReadingConverter readingConverter;
    private Normalizer normalizer;
    private float prefixMatchWeight = 2.0f;
    private boolean matchWordFirst = true;
    private boolean skipDuplicateWords = true;

    public void setIndex(String index) {
        this.index = index;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public void addRole(String role) {
        this.roles.add(role);
    }

    public void addField(String field) {
        this.fields.add(field);
    }

    public void addKind(String kind) {
        this.kinds.add(kind);
    }

    public void setSuggestDetail(boolean suggestDetail) {
        this.suggestDetail = suggestDetail;
    }

    public void setReadingConverter(ReadingConverter readingConverter) {
        this.readingConverter = readingConverter;
    }

    public void setNormalizer(Normalizer normalizer) {
        this.normalizer = normalizer;
    }

    public void setPrefixMatchWeight(float prefixMatchWeight) {
        this.prefixMatchWeight = prefixMatchWeight;
    }

    public void setMatchWordFirst(boolean matchWordFirst) {
        this.matchWordFirst = matchWordFirst;
    }

    public void setSkipDuplicateWords(boolean skipDuplicateWords) {
        this.skipDuplicateWords = skipDuplicateWords;
    }

    public void addLang(String lang) {
        this.languages.add(lang);
    }

    @Override
    protected String getValidationError() {
        return null;
    }

    @Override
    protected void processRequest(Client client, final Deferred<SuggestResponse> deferred) {
        SearchRequestBuilder builder = client.prepareSearch(new String[]{this.index});
        if (this.skipDuplicateWords) {
            builder.setSize(this.size * 2);
        } else {
            builder.setSize(this.size);
        }
        QueryBuilder q = this.buildQuery(this.query, this.fields);
        QueryBuilder queryBuilder = this.buildFunctionScoreQuery(this.query, q);
        builder.addSort("_score", SortOrder.DESC);
        ArrayList<QueryBuilder> filterList = new ArrayList<QueryBuilder>(10);
        if (!this.tags.isEmpty()) {
            filterList.add(this.buildFilterQuery("tags", this.tags));
        }
        this.roles.add("_guest_");
        if (!this.roles.isEmpty()) {
            filterList.add(this.buildFilterQuery("roles", this.roles));
        }
        if (!this.fields.isEmpty()) {
            filterList.add(this.buildFilterQuery("fields", this.fields));
        }
        if (!this.kinds.isEmpty()) {
            filterList.add(this.buildFilterQuery("kinds", this.kinds));
        }
        if (filterList.size() > 0) {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must(queryBuilder);
            filterList.forEach(arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).filter(arg_0));
            builder.setQuery((QueryBuilder)boolQueryBuilder);
        } else {
            builder.setQuery(queryBuilder);
        }
        builder.execute((ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                if (searchResponse.getFailedShards() > 0) {
                    deferred.reject(new SuggesterException("Search failure. Failed shards num:" + searchResponse.getFailedShards()));
                } else {
                    deferred.resolve(SuggestRequest.this.createResponse(searchResponse));
                }
            }

            public void onFailure(Exception e) {
                deferred.reject(new SuggesterException(e.getMessage(), e));
            }
        });
    }

    private boolean isSingleWordQuery(String query) {
        return !Strings.isNullOrEmpty((String)query) && !query.contains(" ") && !query.contains("\u3000");
    }

    protected QueryBuilder buildQuery(String q, List<String> fields) {
        try {
            MatchAllQueryBuilder queryBuilder;
            if (Strings.isNullOrEmpty((String)q)) {
                queryBuilder = QueryBuilders.matchAllQuery();
            } else {
                boolean prefixQuery = !q.endsWith(" ") && !q.endsWith("\u3000");
                List<Object> readingList = new ArrayList<String>();
                String[] langsArray = this.languages.toArray(new String[this.languages.size()]);
                BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                String[] queries = q.replace("\u3000", " ").replaceAll(" +", " ").trim().split(" ");
                for (int i = 0; i < queries.length; ++i) {
                    String fieldName = "reading_" + i;
                    String query = this.normalizer == null ? queries[i] : this.normalizer.normalize(queries[i], "", langsArray);
                    if (this.readingConverter == null) {
                        readingList.add(query);
                    } else {
                        readingList = this.readingConverter.convert(query, "", langsArray);
                    }
                    BoolQueryBuilder readingQueryBuilder = QueryBuilders.boolQuery().minimumShouldMatch(1);
                    int readingNum = readingList.size();
                    for (int readingCount = 0; readingCount < readingNum; ++readingCount) {
                        String reading = (String)readingList.get(readingCount);
                        if (i + 1 == queries.length && prefixQuery) {
                            readingQueryBuilder.should((QueryBuilder)QueryBuilders.prefixQuery((String)fieldName, (String)reading));
                            continue;
                        }
                        readingQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)fieldName, (String)reading));
                    }
                    readingList.clear();
                    boolQueryBuilder.must((QueryBuilder)readingQueryBuilder);
                }
                queryBuilder = boolQueryBuilder;
            }
            return queryBuilder;
        }
        catch (IOException e) {
            throw new SuggesterException("Failed to create queryString.", e);
        }
    }

    protected QueryBuilder buildFilterQuery(String fieldName, List<String> words) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().minimumShouldMatch(1);
        words.stream().forEach(word -> boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)fieldName, (String)word)));
        return boolQueryBuilder;
    }

    protected QueryBuilder buildFunctionScoreQuery(String query, QueryBuilder queryBuilder) {
        ArrayList<FunctionScoreQueryBuilder.FilterFunctionBuilder> flist = new ArrayList<FunctionScoreQueryBuilder.FilterFunctionBuilder>();
        if (this.isSingleWordQuery(query) && !this.isHiraganaQuery(query)) {
            flist.add(new FunctionScoreQueryBuilder.FilterFunctionBuilder((QueryBuilder)QueryBuilders.prefixQuery((String)"text", (String)query), (ScoreFunctionBuilder)ScoreFunctionBuilders.weightFactorFunction((float)this.prefixMatchWeight)));
        }
        flist.add(new FunctionScoreQueryBuilder.FilterFunctionBuilder(ScoreFunctionBuilders.fieldValueFactorFunction((String)"docFreq").missing((double)0.1f).modifier(FieldValueFactorFunction.Modifier.LOG2P).setWeight(1.0f)));
        flist.add(new FunctionScoreQueryBuilder.FilterFunctionBuilder(ScoreFunctionBuilders.fieldValueFactorFunction((String)"queryFreq").missing((double)0.1f).modifier(FieldValueFactorFunction.Modifier.LOG2P).setWeight(1.0f)));
        flist.add(new FunctionScoreQueryBuilder.FilterFunctionBuilder(ScoreFunctionBuilders.fieldValueFactorFunction((String)"userBoost").missing(1.0).setWeight(1.0f)));
        FunctionScoreQueryBuilder functionScoreQueryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryBuilder, (FunctionScoreQueryBuilder.FilterFunctionBuilder[])flist.toArray(new FunctionScoreQueryBuilder.FilterFunctionBuilder[flist.size()]));
        functionScoreQueryBuilder.boostMode(CombineFunction.REPLACE);
        functionScoreQueryBuilder.scoreMode(FunctionScoreQuery.ScoreMode.MULTIPLY);
        return functionScoreQueryBuilder;
    }

    protected SuggestResponse createResponse(SearchResponse searchResponse) {
        SearchHit[] hits = searchResponse.getHits().getHits();
        ArrayList<String> words = new ArrayList<String>();
        ArrayList<String> firstWords = new ArrayList<String>();
        ArrayList<String> secondWords = new ArrayList<String>();
        ArrayList<SuggestItem> firstItems = new ArrayList<SuggestItem>();
        ArrayList<SuggestItem> secondItems = new ArrayList<SuggestItem>();
        String index = hits.length > 0 ? hits[0].getIndex() : "";
        boolean singleWordQuery = this.isSingleWordQuery(this.query);
        boolean hiraganaQuery = this.isHiraganaQuery(this.query);
        for (int i = 0; i < hits.length && words.size() < this.size; ++i) {
            SearchHit hit = hits[i];
            Map source = hit.getSourceAsMap();
            String text = source.get("text").toString();
            if (this.skipDuplicateWords) {
                String duplicateCheckStr = text.replace(" ", "");
                if (words.stream().map(word -> word.replace(" ", "")).anyMatch(word -> word.equals(duplicateCheckStr))) continue;
            }
            words.add(text);
            boolean isFirstWords = this.isFirstWordMatching(singleWordQuery, hiraganaQuery, text);
            if (isFirstWords) {
                firstWords.add(text);
            } else {
                secondWords.add(text);
            }
            if (!this.suggestDetail) continue;
            SuggestItem item = SuggestItem.parseSource(source);
            if (isFirstWords) {
                firstItems.add(item);
                continue;
            }
            secondItems.add(item);
        }
        firstWords.addAll(secondWords);
        firstItems.addAll(secondItems);
        return new SuggestResponse(index, searchResponse.getTook().getMillis(), firstWords, searchResponse.getHits().getTotalHits().value, firstItems);
    }

    protected boolean isFirstWordMatching(boolean singleWordQuery, boolean hiraganaQuery, String text) {
        if (this.matchWordFirst && !hiraganaQuery && singleWordQuery && text.contains(this.query)) {
            if (this.query.length() == 1) {
                return Character.UnicodeBlock.of(this.query.charAt(0)) != Character.UnicodeBlock.HIRAGANA;
            }
            return true;
        }
        return false;
    }

    protected boolean isHiraganaQuery(String query) {
        return query.matches("^[\\u3040-\\u309F]+$");
    }
}

