/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.settings;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.codelibs.core.io.ResourceUtil;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.suggest.analysis.SuggestAnalyzer;
import org.codelibs.fess.suggest.exception.SuggestSettingsException;
import org.codelibs.fess.suggest.settings.SuggestSettings;
import org.codelibs.fess.suggest.util.SuggestUtil;
import org.opensearch.action.admin.indices.analyze.AnalyzeAction;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.opensearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;

public class AnalyzerSettings {
    public static final String READING_ANALYZER = "reading_analyzer";
    public static final String READING_TERM_ANALYZER = "reading_term_analyzer";
    public static final String NORMALIZE_ANALYZER = "normalize_analyzer";
    public static final String CONTENTS_ANALYZER = "contents_analyzer";
    public static final String CONTENTS_READING_ANALYZER = "contents_reading_analyzer";
    public static final String FIELD_ANALYZER_MAPPING = "fieldAnalyzerMapping";
    public static final String DOC_TYPE_NAME = "_doc";
    protected final Client client;
    protected final String analyzerSettingsIndexName;
    private final SuggestSettings settings;
    protected static Map<String, Set<String>> analyzerMap = new ConcurrentHashMap<String, Set<String>>();
    protected static Map<String, Map<String, FieldAnalyzerMapping>> fieldAnalyzerMappingMap = new ConcurrentHashMap<String, Map<String, FieldAnalyzerMapping>>();
    protected static final String[] SUPPORTED_LANGUAGES = new String[]{"ar", "bg", "bn", "ca", "cs", "da", "de", "el", "en", "es", "et", "fa", "fi", "fr", "gu", "he", "hi", "hr", "hu", "id", "it", "ja", "ko", "lt", "lv", "mk", "ml", "nl", "no", "pa", "pl", "pt", "ro", "ru", "si", "sq", "sv", "ta", "te", "th", "tl", "tr", "uk", "ur", "vi", "zh-cn", "zh-tw"};

    public AnalyzerSettings(Client client, SuggestSettings settings, String settingsIndexName) {
        this.client = client;
        this.settings = settings;
        this.analyzerSettingsIndexName = this.createAnalyzerSettingsIndexName(settingsIndexName);
    }

    public synchronized void init() {
        try {
            IndicesExistsResponse response = (IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{this.analyzerSettingsIndexName}).execute().actionGet(this.settings.getIndicesTimeout());
            if (!response.isExists()) {
                this.createAnalyzerSettings(this.loadIndexSettings(), this.loadIndexMapping());
            }
            analyzerMap.put(this.analyzerSettingsIndexName, this.getAnalyzerNames());
            fieldAnalyzerMappingMap.put(this.analyzerSettingsIndexName, this.getFieldAnalyzerMapping());
        }
        catch (IOException e) {
            throw new SuggestSettingsException("Failed to create mappings.");
        }
    }

    public String getAnalyzerSettingsIndexName() {
        return this.analyzerSettingsIndexName;
    }

    public String getReadingAnalyzerName(String field, String lang) {
        String analyzerNameWithlang;
        Map<String, FieldAnalyzerMapping> fieldAnalyzerMapping = fieldAnalyzerMappingMap.get(this.analyzerSettingsIndexName);
        Set<String> analyzerNames = analyzerMap.get(this.analyzerSettingsIndexName);
        String analyzerName = StringUtil.isNotBlank((String)field) && fieldAnalyzerMapping.containsKey(field) && fieldAnalyzerMapping.get((Object)field).readingAnalyzer != null ? fieldAnalyzerMapping.get((Object)field).readingAnalyzer : READING_ANALYZER;
        String string = analyzerNameWithlang = AnalyzerSettings.isSupportedLanguage(lang) ? analyzerName + "_" + lang : analyzerName;
        if (analyzerNames.contains(analyzerNameWithlang)) {
            return analyzerNameWithlang;
        }
        return analyzerName;
    }

    public String getReadingTermAnalyzerName(String field, String lang) {
        String analyzerNameWithlang;
        Map<String, FieldAnalyzerMapping> fieldAnalyzerMapping = fieldAnalyzerMappingMap.get(this.analyzerSettingsIndexName);
        Set<String> analyzerNames = analyzerMap.get(this.analyzerSettingsIndexName);
        String analyzerName = StringUtil.isNotBlank((String)field) && fieldAnalyzerMapping.containsKey(field) && fieldAnalyzerMapping.get((Object)field).readingTermAnalyzer != null ? fieldAnalyzerMapping.get((Object)field).readingTermAnalyzer : READING_TERM_ANALYZER;
        String string = analyzerNameWithlang = AnalyzerSettings.isSupportedLanguage(lang) ? analyzerName + "_" + lang : analyzerName;
        if (analyzerNames.contains(analyzerNameWithlang)) {
            return analyzerNameWithlang;
        }
        return analyzerName;
    }

    public String getNormalizeAnalyzerName(String field, String lang) {
        String analyzerNameWithlang;
        Map<String, FieldAnalyzerMapping> fieldAnalyzerMapping = fieldAnalyzerMappingMap.get(this.analyzerSettingsIndexName);
        Set<String> analyzerNames = analyzerMap.get(this.analyzerSettingsIndexName);
        String analyzerName = StringUtil.isNotBlank((String)field) && fieldAnalyzerMapping.containsKey(field) && fieldAnalyzerMapping.get((Object)field).normalizeAnalyzer != null ? fieldAnalyzerMapping.get((Object)field).normalizeAnalyzer : NORMALIZE_ANALYZER;
        String string = analyzerNameWithlang = AnalyzerSettings.isSupportedLanguage(lang) ? analyzerName + "_" + lang : analyzerName;
        if (analyzerNames.contains(analyzerNameWithlang)) {
            return analyzerNameWithlang;
        }
        return analyzerName;
    }

    public String getContentsAnalyzerName(String field, String lang) {
        String analyzerNameWithlang;
        Map<String, FieldAnalyzerMapping> fieldAnalyzerMapping = fieldAnalyzerMappingMap.get(this.analyzerSettingsIndexName);
        Set<String> analyzerNames = analyzerMap.get(this.analyzerSettingsIndexName);
        String analyzerName = StringUtil.isNotBlank((String)field) && fieldAnalyzerMapping.containsKey(field) && fieldAnalyzerMapping.get((Object)field).contentsAnalyzer != null ? fieldAnalyzerMapping.get((Object)field).contentsAnalyzer : CONTENTS_ANALYZER;
        String string = analyzerNameWithlang = AnalyzerSettings.isSupportedLanguage(lang) ? analyzerName + "_" + lang : analyzerName;
        if (analyzerNames.contains(analyzerNameWithlang)) {
            return analyzerNameWithlang;
        }
        return analyzerName;
    }

    public String getContentsReadingAnalyzerName(String field, String lang) {
        String analyzerNameWithlang;
        Map<String, FieldAnalyzerMapping> fieldAnalyzerMapping = fieldAnalyzerMappingMap.get(this.analyzerSettingsIndexName);
        Set<String> analyzerNames = analyzerMap.get(this.analyzerSettingsIndexName);
        String analyzerName = StringUtil.isNotBlank((String)field) && fieldAnalyzerMapping.containsKey(field) && fieldAnalyzerMapping.get((Object)field).contentsReadingAnalyzer != null ? fieldAnalyzerMapping.get((Object)field).contentsReadingAnalyzer : CONTENTS_READING_ANALYZER;
        String string = analyzerNameWithlang = AnalyzerSettings.isSupportedLanguage(lang) ? analyzerName + "_" + lang : analyzerName;
        if (analyzerNames.contains(analyzerNameWithlang)) {
            return analyzerNameWithlang;
        }
        return analyzerName;
    }

    public void updateAnalyzer(Map<String, Object> settings) {
        this.client.admin().indices().prepareCreate(this.analyzerSettingsIndexName).setSettings(settings).execute().actionGet(this.settings.getIndicesTimeout());
    }

    protected void deleteAnalyzerSettings() {
        this.client.admin().indices().prepareDelete(new String[]{this.analyzerSettingsIndexName}).execute().actionGet(this.settings.getIndicesTimeout());
    }

    protected void createAnalyzerSettings(String settings, String mappings) {
        this.client.admin().indices().prepareCreate(this.analyzerSettingsIndexName).setSettings(settings, (MediaType)XContentType.JSON).setMapping(mappings).execute().actionGet(this.settings.getIndicesTimeout());
    }

    protected void createAnalyzerSettings(Map<String, Object> settings, Map<String, Object> mappings) {
        this.client.admin().indices().prepareCreate(this.analyzerSettingsIndexName).setSettings(settings).execute().actionGet(this.settings.getIndicesTimeout());
    }

    protected String createAnalyzerSettingsIndexName(String settingsIndexName) {
        return settingsIndexName + "_analyzer";
    }

    protected String loadIndexSettings() throws IOException {
        String dictionaryPath = System.getProperty("fess.dictionary.path", "");
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(this.getSuggestAnalyzerPath())));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        return sb.toString().replaceAll(Pattern.quote("${fess.dictionary.path}"), dictionaryPath);
    }

    protected String getSuggestAnalyzerPath() {
        String path;
        Object typeObj = this.settings.get("search_engine.type");
        if (typeObj != null && ResourceUtil.getResourceNoException((String)(path = "suggest_indices/_" + typeObj.toString() + "/suggest_analyzer.json")) != null) {
            return path;
        }
        return "suggest_indices/suggest_analyzer.json";
    }

    protected String loadIndexMapping() throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("suggest_indices/analyzer/mapping-default.json")));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isSupportedLanguage(String lang) {
        if (!StringUtil.isNotBlank((String)lang)) return false;
        if (!Stream.of(SUPPORTED_LANGUAGES).anyMatch(lang::equals)) return false;
        return true;
    }

    protected Set<String> getAnalyzerNames() {
        GetSettingsResponse response = (GetSettingsResponse)this.client.admin().indices().prepareGetSettings(new String[0]).setIndices(new String[]{this.analyzerSettingsIndexName}).execute().actionGet();
        Settings settings = (Settings)response.getIndexToSettings().get(this.analyzerSettingsIndexName);
        Settings analyzerSettings = settings.getAsSettings("index.analysis.analyzer");
        return analyzerSettings.getAsGroups().keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, FieldAnalyzerMapping> getFieldAnalyzerMapping() {
        HashMap<String, FieldAnalyzerMapping> mappingMap = new HashMap<String, FieldAnalyzerMapping>();
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.analyzerSettingsIndexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"settingsType", (String)FIELD_ANALYZER_MAPPING)).setScroll(this.settings.getScrollTimeout()).execute().actionGet(this.settings.getSearchTimeout());
        String scrollId = response.getScrollId();
        try {
            while (scrollId != null) {
                SearchHit[] hits = response.getHits().getHits();
                if (hits.length == 0) {
                    break;
                }
                for (SearchHit hit : hits) {
                    Map source = hit.getSourceAsMap();
                    String fieldReadingAnalyzer = source.get("readingAnalyzer") == null ? null : source.get("readingAnalyzer").toString();
                    String fieldReadingTermAnalyzer = source.get("readingTermAnalyzer") == null ? null : source.get("readingTermAnalyzer").toString();
                    String fieldNormalizeAnalyzer = source.get("normalizeAnalyzer") == null ? null : source.get("normalizeAnalyzer").toString();
                    String fieldContentsAnalyzer = source.get("contentsAnalyzer") == null ? null : source.get("contentsAnalyzer").toString();
                    String fieldContentsReadingAnalyzer = source.get("contentsReadingAnalyzer") == null ? null : source.get("contentsReadingAnalyzer").toString();
                    mappingMap.put(source.get("fieldName").toString(), new FieldAnalyzerMapping(fieldReadingAnalyzer, fieldReadingTermAnalyzer, fieldNormalizeAnalyzer, fieldContentsAnalyzer, fieldContentsReadingAnalyzer));
                }
                response = (SearchResponse)this.client.prepareSearchScroll(scrollId).setScroll(this.settings.getScrollTimeout()).execute().actionGet(this.settings.getSearchTimeout());
                if (!scrollId.equals(response.getScrollId())) {
                    SuggestUtil.deleteScrollContext(this.client, scrollId);
                }
                scrollId = response.getScrollId();
            }
        }
        finally {
            SuggestUtil.deleteScrollContext(this.client, scrollId);
        }
        return mappingMap;
    }

    public Set<String> checkAnalyzer() {
        String text = "text";
        HashSet<String> undefinedAnalyzerSet = new HashSet<String>();
        for (String lang : SUPPORTED_LANGUAGES) {
            String readingAnalyzer = this.getReadingAnalyzerName("", lang);
            try {
                this.client.admin().indices().prepareAnalyze(this.analyzerSettingsIndexName, "text").setAnalyzer(readingAnalyzer).execute().actionGet(this.settings.getIndicesTimeout());
            }
            catch (IllegalArgumentException e) {
                undefinedAnalyzerSet.add(readingAnalyzer);
            }
            String readingTermAnalyzer = this.getReadingTermAnalyzerName("", lang);
            try {
                this.client.admin().indices().prepareAnalyze(this.analyzerSettingsIndexName, "text").setAnalyzer(readingTermAnalyzer).execute().actionGet(this.settings.getIndicesTimeout());
            }
            catch (IllegalArgumentException e) {
                undefinedAnalyzerSet.add(readingTermAnalyzer);
            }
            String normalizeAnalyzer = this.getNormalizeAnalyzerName("", lang);
            try {
                this.client.admin().indices().prepareAnalyze(this.analyzerSettingsIndexName, "text").setAnalyzer(normalizeAnalyzer).execute().actionGet(this.settings.getIndicesTimeout());
            }
            catch (IllegalArgumentException e) {
                undefinedAnalyzerSet.add(normalizeAnalyzer);
            }
            String contentsAnalyzer = this.getContentsAnalyzerName("", lang);
            try {
                this.client.admin().indices().prepareAnalyze(this.analyzerSettingsIndexName, "text").setAnalyzer(contentsAnalyzer).execute().actionGet(this.settings.getIndicesTimeout());
            }
            catch (IllegalArgumentException e) {
                undefinedAnalyzerSet.add(contentsAnalyzer);
            }
            String contentsReadingAnalyzer = this.getContentsReadingAnalyzerName("", lang);
            try {
                this.client.admin().indices().prepareAnalyze(this.analyzerSettingsIndexName, "text").setAnalyzer(contentsReadingAnalyzer).execute().actionGet(this.settings.getIndicesTimeout());
            }
            catch (IllegalArgumentException e) {
                undefinedAnalyzerSet.add(contentsReadingAnalyzer);
            }
        }
        return undefinedAnalyzerSet;
    }

    protected static class FieldAnalyzerMapping {
        protected final String readingAnalyzer;
        protected final String readingTermAnalyzer;
        protected final String normalizeAnalyzer;
        protected final String contentsAnalyzer;
        protected final String contentsReadingAnalyzer;

        public FieldAnalyzerMapping(String readingAnalyzer, String readingTermAnalyzer, String normalizeAnalyzer, String contentsAnalyzer, String contentsReadingAnalyzer) {
            this.readingAnalyzer = readingAnalyzer;
            this.readingTermAnalyzer = readingTermAnalyzer;
            this.normalizeAnalyzer = normalizeAnalyzer;
            this.contentsAnalyzer = contentsAnalyzer;
            this.contentsReadingAnalyzer = contentsReadingAnalyzer;
        }
    }

    public class DefaultContentsAnalyzer
    implements SuggestAnalyzer {
        private final int maxContentLenth;

        public DefaultContentsAnalyzer() {
            this.maxContentLenth = AnalyzerSettings.this.settings.getAsInt("maxContextLength", 50000);
        }

        @Override
        public List<AnalyzeAction.AnalyzeToken> analyze(String text, String field, String lang) {
            if (text == null || text.length() > this.maxContentLenth) {
                return Collections.emptyList();
            }
            AnalyzeAction.Response analyzeResponse = (AnalyzeAction.Response)AnalyzerSettings.this.client.admin().indices().prepareAnalyze(AnalyzerSettings.this.analyzerSettingsIndexName, text).setAnalyzer(AnalyzerSettings.this.getContentsAnalyzerName(field, lang)).execute().actionGet(AnalyzerSettings.this.settings.getIndicesTimeout());
            return analyzeResponse.getTokens();
        }

        @Override
        public List<AnalyzeAction.AnalyzeToken> analyzeAndReading(String text, String field, String lang) {
            try {
                String contentsReadingAnalyzerName = AnalyzerSettings.this.getContentsReadingAnalyzerName(field, lang);
                if (StringUtil.isBlank((String)contentsReadingAnalyzerName)) {
                    return null;
                }
                AnalyzeAction.Response analyzeResponse = (AnalyzeAction.Response)AnalyzerSettings.this.client.admin().indices().prepareAnalyze(AnalyzerSettings.this.analyzerSettingsIndexName, text).setAnalyzer(contentsReadingAnalyzerName).execute().actionGet(AnalyzerSettings.this.settings.getIndicesTimeout());
                return analyzeResponse.getTokens();
            }
            catch (IllegalArgumentException e) {
                return this.analyze(text, field, lang);
            }
        }
    }
}

