/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.settings;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codelibs.fess.suggest.exception.SuggestSettingsException;
import org.codelibs.fess.suggest.settings.ArraySettings;
import org.codelibs.fess.suggest.settings.SuggestSettings;
import org.opensearch.client.Client;
import org.opensearch.core.common.Strings;

public class BadWordSettings {
    private static final Logger logger = LogManager.getLogger(BadWordSettings.class);
    public static final String BAD_WORD_SETTINGD_KEY = "badword";
    protected ArraySettings arraySettings;
    protected static String[] defaultWords = null;

    protected BadWordSettings(SuggestSettings settings, Client client, String settingsIndexName, String settingsId) {
        this.arraySettings = new ArraySettings(settings, client, settingsIndexName, settingsId){

            @Override
            protected String createArraySettingsIndexName(String settingsIndexName) {
                return settingsIndexName + "_badword";
            }
        };
    }

    public String[] get(boolean includeDefault) {
        String[] badWords = this.arraySettings.get(BAD_WORD_SETTINGD_KEY);
        if (!includeDefault) {
            return badWords;
        }
        if (defaultWords == null) {
            BadWordSettings.updateDefaultBadwords();
        }
        String[] concat = new String[defaultWords.length + badWords.length];
        System.arraycopy(badWords, 0, concat, 0, badWords.length);
        System.arraycopy(defaultWords, 0, concat, badWords.length, defaultWords.length);
        return concat;
    }

    public void add(String badWord) {
        String validationError;
        if (logger.isDebugEnabled()) {
            logger.debug("Add badword. {} badword: {}", (Object)this.arraySettings.arraySettingsIndexName, (Object)badWord);
        }
        if ((validationError = this.getValidationError(badWord)) != null) {
            throw new IllegalArgumentException("Validation error. " + validationError);
        }
        this.arraySettings.add(BAD_WORD_SETTINGD_KEY, badWord);
    }

    public void delete(String badWord) {
        if (logger.isDebugEnabled()) {
            logger.debug("Delete badword. {} badword: {}", (Object)this.arraySettings.arraySettingsIndexName, (Object)badWord);
        }
        this.arraySettings.delete(BAD_WORD_SETTINGD_KEY, badWord);
    }

    public void deleteAll() {
        if (logger.isDebugEnabled()) {
            logger.debug("Add all badword. {}", (Object)this.arraySettings.arraySettingsIndexName);
        }
        this.arraySettings.delete(BAD_WORD_SETTINGD_KEY);
    }

    protected String getValidationError(String badWord) {
        if (Strings.isNullOrEmpty((String)badWord)) {
            return "badWord was empty.";
        }
        if (badWord.contains(" ") || badWord.contains("  ")) {
            return "badWord contains space.";
        }
        return null;
    }

    protected static void updateDefaultBadwords() {
        if (defaultWords != null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("suggest_settings/default-badwords.txt")));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.length() <= 0 || line.startsWith("#")) continue;
                list.add(line.trim());
            }
        }
        catch (Exception e) {
            throw new SuggestSettingsException("Failed to load default badwords.", e);
        }
        defaultWords = list.toArray(new String[list.size()]);
    }
}

