/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.settings;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codelibs.fess.suggest.entity.ElevateWord;
import org.codelibs.fess.suggest.settings.ArraySettings;
import org.codelibs.fess.suggest.settings.SuggestSettings;
import org.opensearch.client.Client;

public class ElevateWordSettings {
    private static final Logger logger = LogManager.getLogger(ElevateWordSettings.class);
    public static final String ELEVATE_WORD_SETTINGD_KEY = "elevateword";
    public static final String ELEVATE_WORD_BOOST = "boost";
    public static final String ELEVATE_WORD_READING = "reading";
    public static final String ELEVATE_WORD_FIELDS = "fields";
    public static final String ELEVATE_WORD_TAGS = "tags";
    public static final String ELEVATE_WORD_ROLES = "roles";
    protected ArraySettings arraySettings;

    protected ElevateWordSettings(SuggestSettings settings, Client client, String settingsIndexName, String settingsId) {
        this.arraySettings = new ArraySettings(settings, client, settingsIndexName, settingsId){

            @Override
            protected String createArraySettingsIndexName(String settingsIndexName) {
                return settingsIndexName + "_elevate";
            }
        };
    }

    public ElevateWord[] get() {
        Map<String, Object>[] sourceArray = this.arraySettings.getFromArrayIndex(this.arraySettings.arraySettingsIndexName, this.arraySettings.settingsId, ELEVATE_WORD_SETTINGD_KEY);
        ElevateWord[] elevateWords = new ElevateWord[sourceArray.length];
        for (int i = 0; i < elevateWords.length; ++i) {
            Object elevateWord = sourceArray[i].get("value");
            Object boost = sourceArray[i].get(ELEVATE_WORD_BOOST);
            List readings = (List)sourceArray[i].get(ELEVATE_WORD_READING);
            List fields = (List)sourceArray[i].get(ELEVATE_WORD_FIELDS);
            List tags = (List)sourceArray[i].get(ELEVATE_WORD_TAGS);
            List roles = (List)sourceArray[i].get(ELEVATE_WORD_ROLES);
            if (elevateWord == null || boost == null || readings == null || fields == null) continue;
            elevateWords[i] = new ElevateWord(elevateWord.toString(), Float.parseFloat(boost.toString()), readings, fields, tags, roles);
        }
        return elevateWords;
    }

    public void add(ElevateWord elevateWord) {
        if (logger.isDebugEnabled()) {
            logger.debug("Add elevateword. {}  elevateword: {}", (Object)this.arraySettings.arraySettingsIndexName, (Object)elevateWord.getElevateWord());
        }
        HashMap<String, Object> source = new HashMap<String, Object>();
        source.put("key", ELEVATE_WORD_SETTINGD_KEY);
        source.put("value", elevateWord.getElevateWord());
        source.put(ELEVATE_WORD_BOOST, Float.valueOf(elevateWord.getBoost()));
        source.put(ELEVATE_WORD_READING, elevateWord.getReadings());
        source.put(ELEVATE_WORD_FIELDS, elevateWord.getFields());
        source.put(ELEVATE_WORD_TAGS, elevateWord.getTags());
        source.put(ELEVATE_WORD_ROLES, elevateWord.getRoles());
        source.put("@timestamp", DateTimeFormatter.ISO_INSTANT.format(ZonedDateTime.now()));
        this.arraySettings.addToArrayIndex(this.arraySettings.arraySettingsIndexName, this.arraySettings.settingsId, this.arraySettings.createId(ELEVATE_WORD_SETTINGD_KEY, elevateWord.getElevateWord()), source);
    }

    public void delete(String elevateWord) {
        if (logger.isDebugEnabled()) {
            logger.debug("Delete elevateword. {} elevateword: {}", (Object)this.arraySettings.arraySettingsIndexName, (Object)elevateWord);
        }
        this.arraySettings.delete(ELEVATE_WORD_SETTINGD_KEY, elevateWord);
    }

    public void deleteAll() {
        if (logger.isDebugEnabled()) {
            logger.debug("Delete all elevateword. {}", (Object)this.arraySettings.arraySettingsIndexName);
        }
        this.arraySettings.delete(ELEVATE_WORD_SETTINGD_KEY);
    }
}

