/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.codelibs.core.CoreLibConstants;
import org.codelibs.fess.suggest.converter.AnalyzerConverter;
import org.codelibs.fess.suggest.converter.KatakanaToAlphabetConverter;
import org.codelibs.fess.suggest.converter.ReadingConverter;
import org.codelibs.fess.suggest.converter.ReadingConverterChain;
import org.codelibs.fess.suggest.entity.SuggestItem;
import org.codelibs.fess.suggest.exception.SuggesterException;
import org.codelibs.fess.suggest.normalizer.AnalyzerNormalizer;
import org.codelibs.fess.suggest.normalizer.Normalizer;
import org.codelibs.fess.suggest.normalizer.NormalizerChain;
import org.codelibs.fess.suggest.settings.AnalyzerSettings;
import org.codelibs.fess.suggest.settings.SuggestSettings;
import org.opensearch.action.bulk.BulkRequestBuilder;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.search.SearchHit;

public final class SuggestUtil {
    private static final int MAX_QUERY_TERM_NUM = 5;
    private static final int MAX_QUERY_TERM_LENGTH = 48;
    private static final Base64.Encoder encoder = Base64.getEncoder();
    private static final int ID_MAX_LENGTH = 445;

    private SuggestUtil() {
    }

    public static String createSuggestTextId(String text) {
        String id = encoder.encodeToString(text.getBytes(CoreLibConstants.CHARSET_UTF_8));
        if (id.length() > 445) {
            return id.substring(0, 445);
        }
        return id;
    }

    public static String[] parseQuery(String q, String field) {
        List<String> keywords = SuggestUtil.getKeywords(q, new String[]{field});
        if (5 < keywords.size()) {
            return new String[0];
        }
        for (String k : keywords) {
            if (48 >= k.length()) continue;
            return new String[0];
        }
        return keywords.toArray(new String[keywords.size()]);
    }

    public static List<String> getKeywords(String q, String[] fields) {
        List<TermQuery> termQueryList;
        ArrayList<String> keywords = new ArrayList<String>();
        try {
            StandardQueryParser parser = new StandardQueryParser();
            parser.setDefaultOperator(StandardQueryConfigHandler.Operator.AND);
            termQueryList = SuggestUtil.getTermQueryList(parser.parse(q, "default"), fields);
        }
        catch (Exception e) {
            return keywords;
        }
        for (TermQuery tq : termQueryList) {
            String text = tq.getTerm().text();
            if (0 == text.length() || keywords.contains(text)) continue;
            keywords.add(text);
        }
        return keywords;
    }

    public static List<TermQuery> getTermQueryList(Query query, String[] fields) {
        if (query instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query;
            List clauses = booleanQuery.clauses();
            ArrayList<TermQuery> queryList = new ArrayList<TermQuery>();
            for (BooleanClause clause : clauses) {
                Query q = clause.getQuery();
                if (q instanceof BooleanQuery) {
                    queryList.addAll(SuggestUtil.getTermQueryList(q, fields));
                    continue;
                }
                if (!(q instanceof TermQuery)) continue;
                TermQuery termQuery = (TermQuery)q;
                for (String field : fields) {
                    if (!field.equals(termQuery.getTerm().field())) continue;
                    queryList.add(termQuery);
                }
            }
            return queryList;
        }
        if (query instanceof TermQuery) {
            TermQuery termQuery = (TermQuery)query;
            for (String field : fields) {
                if (!field.equals(termQuery.getTerm().field())) continue;
                ArrayList<TermQuery> queryList = new ArrayList<TermQuery>(1);
                queryList.add(termQuery);
                return queryList;
            }
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String createBulkLine(String index, String type, SuggestItem item) {
        HashMap<String, Object> firstLineMap = new HashMap<String, Object>();
        HashMap<String, String> firstLineInnerMap = new HashMap<String, String>();
        firstLineInnerMap.put("_index", index);
        firstLineInnerMap.put("_type", type);
        firstLineInnerMap.put("_id", item.getId());
        firstLineMap.put("index", firstLineInnerMap);
        HashMap<String, Object> secondLine = new HashMap<String, Object>();
        secondLine.put("text", item.getText());
        String[][] readings = item.getReadings();
        for (int i = 0; i < readings.length; ++i) {
            secondLine.put("reading_" + i, readings[i]);
        }
        secondLine.put("fields", item.getFields());
        secondLine.put("queryFreq", item.getQueryFreq());
        secondLine.put("docFreq", item.getDocFreq());
        secondLine.put("userBoost", Float.valueOf(item.getUserBoost()));
        secondLine.put("score", Float.valueOf((float)(item.getQueryFreq() + item.getDocFreq()) * item.getUserBoost()));
        secondLine.put("tags", item.getTags());
        secondLine.put("roles", item.getRoles());
        secondLine.put("kinds", Arrays.toString((Object[])item.getKinds()));
        secondLine.put("@timestamp", item.getTimestamp());
        try (OutputStream out1 = SuggestUtil.getXContentOutputStream(firstLineMap);){
            String string;
            block15: {
                OutputStream out2 = SuggestUtil.getXContentOutputStream(secondLine);
                try {
                    string = ((ByteArrayOutputStream)out1).toString("UTF-8") + "\n" + ((ByteArrayOutputStream)out2).toString("UTF-8");
                    if (out2 == null) break block15;
                }
                catch (Throwable throwable) {
                    if (out2 != null) {
                        try {
                            out2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                out2.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new SuggesterException(e);
        }
    }

    private static OutputStream getXContentOutputStream(Map<String, Object> firstLineMap) throws IOException {
        try (XContentBuilder builder = JsonXContent.contentBuilder().map(firstLineMap);){
            builder.flush();
            OutputStream outputStream = builder.getOutputStream();
            return outputStream;
        }
    }

    public static ReadingConverter createDefaultReadingConverter(Client client, SuggestSettings settings) {
        ReadingConverterChain chain = new ReadingConverterChain();
        chain.addConverter(new AnalyzerConverter(client, settings));
        chain.addConverter(new KatakanaToAlphabetConverter());
        return chain;
    }

    public static ReadingConverter createDefaultContentsReadingConverter(Client client, SuggestSettings settings) {
        ReadingConverterChain chain = new ReadingConverterChain();
        chain.addConverter(new KatakanaToAlphabetConverter());
        return chain;
    }

    public static Normalizer createDefaultNormalizer(Client client, SuggestSettings settings) {
        NormalizerChain normalizerChain = new NormalizerChain();
        normalizerChain.add(new AnalyzerNormalizer(client, settings));
        return normalizerChain;
    }

    public static AnalyzerSettings.DefaultContentsAnalyzer createDefaultAnalyzer(Client client, SuggestSettings settings) {
        AnalyzerSettings analyzerSettings = settings.analyzer();
        return analyzerSettings.new AnalyzerSettings.DefaultContentsAnalyzer();
    }

    public static List<String> getAsList(Object value) {
        if (value == null) {
            return new ArrayList<String>();
        }
        if (value instanceof String) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(value.toString());
            return list;
        }
        if (value instanceof List) {
            return (List)value;
        }
        throw new IllegalArgumentException("The value should be String or List, but " + value.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteByQuery(Client client, SuggestSettings settings, String index, QueryBuilder queryBuilder) {
        try {
            SearchResponse response = (SearchResponse)client.prepareSearch(new String[]{index}).setQuery(queryBuilder).setSize(500).setScroll(settings.getScrollTimeout()).execute().actionGet(settings.getSearchTimeout());
            String scrollId = response.getScrollId();
            try {
                while (scrollId != null) {
                    SearchHit[] hits = response.getHits().getHits();
                    if (hits.length == 0) {
                        break;
                    }
                    BulkRequestBuilder bulkRequestBuiler = client.prepareBulk();
                    Stream.of(hits).map(SearchHit::getId).forEach(id -> bulkRequestBuiler.add(new DeleteRequest(index, id)));
                    BulkResponse bulkResponse = (BulkResponse)bulkRequestBuiler.execute().actionGet(settings.getBulkTimeout());
                    if (bulkResponse.hasFailures()) {
                        throw new SuggesterException(bulkResponse.buildFailureMessage());
                    }
                    response = (SearchResponse)client.prepareSearchScroll(scrollId).setScroll(settings.getScrollTimeout()).execute().actionGet(settings.getSearchTimeout());
                    if (!scrollId.equals(response.getScrollId())) {
                        SuggestUtil.deleteScrollContext(client, scrollId);
                    }
                    scrollId = response.getScrollId();
                }
            }
            finally {
                SuggestUtil.deleteScrollContext(client, scrollId);
            }
            client.admin().indices().prepareRefresh(new String[]{index}).execute().actionGet(settings.getIndicesTimeout());
        }
        catch (Exception e) {
            throw new SuggesterException("Failed to exec delete by query.", e);
        }
        return true;
    }

    public static void deleteScrollContext(Client client, String scrollId) {
        if (scrollId != null) {
            client.prepareClearScroll().addScrollId(scrollId).execute(ActionListener.wrap(res -> {}, e -> {}));
        }
    }

    public static String escapeWildcardQuery(String query) {
        return query.replace("*", "\\*").replace("?", "\\?");
    }
}

