/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codelibs.fess.suggest.SuggesterBuilder;
import org.codelibs.fess.suggest.analysis.SuggestAnalyzer;
import org.codelibs.fess.suggest.converter.ReadingConverter;
import org.codelibs.fess.suggest.exception.SuggesterException;
import org.codelibs.fess.suggest.index.SuggestIndexer;
import org.codelibs.fess.suggest.normalizer.Normalizer;
import org.codelibs.fess.suggest.request.popularwords.PopularWordsRequestBuilder;
import org.codelibs.fess.suggest.request.suggest.SuggestRequestBuilder;
import org.codelibs.fess.suggest.settings.SuggestSettings;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.opensearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.opensearch.action.admin.indices.get.GetIndexRequestBuilder;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.action.admin.indices.refresh.RefreshResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;

public class Suggester {
    private static final Logger logger = LogManager.getLogger(Suggester.class);
    protected final Client client;
    protected final SuggestSettings suggestSettings;
    protected final ReadingConverter readingConverter;
    protected final ReadingConverter contentsReadingConverter;
    protected final Normalizer normalizer;
    protected final SuggestAnalyzer analyzer;
    protected final String index;
    protected final ExecutorService threadPool;

    public Suggester(Client client, SuggestSettings settings, ReadingConverter readingConverter, ReadingConverter contentsReadingConverter, Normalizer normalizer, SuggestAnalyzer analyzer, ExecutorService threadPool) {
        this.client = client;
        this.suggestSettings = settings;
        this.readingConverter = readingConverter;
        this.contentsReadingConverter = contentsReadingConverter;
        this.normalizer = normalizer;
        this.analyzer = analyzer;
        this.index = settings.getAsString("index", "");
        this.threadPool = threadPool;
        if (logger.isDebugEnabled()) {
            logger.debug("Create suggester instance for {}", (Object)this.index);
        }
    }

    public SuggestRequestBuilder suggest() {
        return new SuggestRequestBuilder(this.client, this.readingConverter, this.normalizer).setIndex(this.getSearchAlias(this.index));
    }

    public PopularWordsRequestBuilder popularWords() {
        return new PopularWordsRequestBuilder(this.client).setIndex(this.getSearchAlias(this.index));
    }

    public RefreshResponse refresh() {
        return (RefreshResponse)this.client.admin().indices().prepareRefresh(new String[0]).execute().actionGet(this.suggestSettings.getIndexTimeout());
    }

    public void shutdown() {
        this.threadPool.shutdownNow();
    }

    public boolean createIndexIfNothing() {
        try {
            boolean created = false;
            IndicesExistsResponse response = (IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{this.getSearchAlias(this.index)}).execute().actionGet(this.suggestSettings.getIndicesTimeout());
            if (!response.isExists()) {
                String mappingSource = this.getDefaultMappings();
                String settingsSource = this.getDefaultIndexSettings();
                String indexName = this.createIndexName(this.index);
                if (logger.isInfoEnabled()) {
                    logger.info("Create suggest index: {}", (Object)indexName);
                }
                this.client.admin().indices().prepareCreate(indexName).setSettings(settingsSource, (MediaType)XContentType.JSON).setMapping(mappingSource).addAlias(new Alias(this.getSearchAlias(this.index))).addAlias(new Alias(this.getUpdateAlias(this.index))).execute().actionGet(this.suggestSettings.getIndicesTimeout());
                this.client.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().execute().actionGet(this.suggestSettings.getClusterTimeout());
                created = true;
            }
            return created;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to create index. index: {}", (Object)this.index, (Object)e);
            }
            throw new SuggesterException("Failed to create index.", e);
        }
    }

    public void createNextIndex() {
        try {
            CreateIndexResponse createIndexResponse;
            ArrayList prevIndices = new ArrayList();
            IndicesExistsResponse response = (IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{this.getUpdateAlias(this.index)}).execute().actionGet(this.suggestSettings.getIndicesTimeout());
            if (response.isExists()) {
                GetAliasesResponse getAliasesResponse = (GetAliasesResponse)this.client.admin().indices().prepareGetAliases(new String[]{this.getUpdateAlias(this.index)}).execute().actionGet(this.suggestSettings.getIndicesTimeout());
                getAliasesResponse.getAliases().keySet().forEach(prevIndices::add);
            }
            String mappingSource = this.getDefaultMappings();
            String settingsSource = this.getDefaultIndexSettings();
            String indexName = this.createIndexName(this.index);
            if (logger.isInfoEnabled()) {
                logger.info("Create next index: {}", (Object)indexName);
            }
            if (!(createIndexResponse = (CreateIndexResponse)this.client.admin().indices().prepareCreate(indexName).setSettings(settingsSource, (MediaType)XContentType.JSON).setMapping(mappingSource).execute().actionGet(this.suggestSettings.getIndicesTimeout())).isAcknowledged()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Could not create next index: {}", (Object)indexName);
                }
                throw new SuggesterException("Could not create next index: " + indexName);
            }
            this.client.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().execute().actionGet(this.suggestSettings.getClusterTimeout());
            IndicesAliasesRequestBuilder aliasesRequestBuilder = this.client.admin().indices().prepareAliases().addAlias(indexName, this.getUpdateAlias(this.index));
            for (String prevIndex : prevIndices) {
                aliasesRequestBuilder.removeAlias(prevIndex, this.getUpdateAlias(this.index));
            }
            aliasesRequestBuilder.execute().actionGet(this.suggestSettings.getIndicesTimeout());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to replace with new index.", (Throwable)e);
            }
            throw new SuggesterException("Failed to replace with new index.", e);
        }
    }

    public void switchIndex() {
        try {
            ArrayList updateIndices = new ArrayList();
            String updateAlias = this.getUpdateAlias(this.index);
            IndicesExistsResponse updateIndicesResponse = (IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{updateAlias}).execute().actionGet(this.suggestSettings.getIndicesTimeout());
            if (updateIndicesResponse.isExists()) {
                GetAliasesResponse getAliasesResponse = (GetAliasesResponse)this.client.admin().indices().prepareGetAliases(new String[]{updateAlias}).execute().actionGet(this.suggestSettings.getIndicesTimeout());
                getAliasesResponse.getAliases().entrySet().forEach(x -> ((List)x.getValue()).stream().filter(y -> updateAlias.equals(y.alias())).forEach(y -> updateIndices.add((String)x.getKey())));
            }
            if (updateIndices.size() != 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unexpected update indices num: {}", (Object)updateIndices.size());
                }
                throw new SuggesterException("Unexpected update indices num:" + updateIndices.size());
            }
            String updateIndex = (String)updateIndices.get(0);
            ArrayList searchIndices = new ArrayList();
            String searchAlias = this.getSearchAlias(this.index);
            IndicesExistsResponse searchIndicesResponse = (IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{searchAlias}).execute().actionGet(this.suggestSettings.getIndicesTimeout());
            if (searchIndicesResponse.isExists()) {
                GetAliasesResponse getAliasesResponse = (GetAliasesResponse)this.client.admin().indices().prepareGetAliases(new String[]{searchAlias}).execute().actionGet(this.suggestSettings.getIndicesTimeout());
                getAliasesResponse.getAliases().entrySet().forEach(x -> ((List)x.getValue()).stream().filter(y -> searchAlias.equals(y.alias())).forEach(y -> searchIndices.add((String)x.getKey())));
            }
            if (searchIndices.size() != 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unexpected update indices num: {}", (Object)searchIndices.size());
                }
                throw new SuggesterException("Unexpected search indices num:" + searchIndices.size());
            }
            String searchIndex = (String)searchIndices.get(0);
            if (updateIndex.equals(searchIndex)) {
                return;
            }
            if (logger.isInfoEnabled()) {
                logger.info("Switch suggest.search index. {} => {}", (Object)searchIndex, (Object)updateIndex);
            }
            this.client.admin().indices().prepareAliases().removeAlias(searchIndex, searchAlias).addAlias(updateIndex, searchAlias).execute().actionGet(this.suggestSettings.getIndicesTimeout());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to switch index.", (Throwable)e);
            }
            throw new SuggesterException("Failed to switch index.", e);
        }
    }

    public void removeDisableIndices() {
        GetIndexResponse response = (GetIndexResponse)((GetIndexRequestBuilder)this.client.admin().indices().prepareGetIndex().addIndices(new String[]{"*"})).execute().actionGet(this.suggestSettings.getIndicesTimeout());
        Stream.of(response.getIndices()).filter(s -> {
            if (!this.isSuggestIndex((String)s)) {
                return false;
            }
            List list = (List)response.getAliases().get(s);
            if (list == null) {
                return true;
            }
            return list.isEmpty();
        }).forEach(s -> {
            if (logger.isInfoEnabled()) {
                logger.info("Delete index: {}", s);
            }
            this.client.admin().indices().prepareDelete(new String[]{s}).execute().actionGet(this.suggestSettings.getIndicesTimeout());
        });
    }

    public SuggestIndexer indexer() {
        return this.createDefaultIndexer();
    }

    public static SuggesterBuilder builder() {
        return new SuggesterBuilder();
    }

    public SuggestSettings settings() {
        return this.suggestSettings;
    }

    public ReadingConverter getReadingConverter() {
        return this.readingConverter;
    }

    public Normalizer getNormalizer() {
        return this.normalizer;
    }

    protected SuggestIndexer createDefaultIndexer() {
        return new SuggestIndexer(this.client, this.getUpdateAlias(this.index), this.readingConverter, this.contentsReadingConverter, this.normalizer, this.analyzer, this.suggestSettings, this.threadPool);
    }

    public String getIndex() {
        return this.index;
    }

    public long getAllWordsNum() {
        return this.getNum((QueryBuilder)QueryBuilders.matchAllQuery());
    }

    public long getDocumentWordsNum() {
        return this.getNum((QueryBuilder)QueryBuilders.rangeQuery((String)"docFreq").gte((Object)1));
    }

    public long getQueryWordsNum() {
        return this.getNum((QueryBuilder)QueryBuilders.rangeQuery((String)"queryFreq").gte((Object)1));
    }

    private long getNum(QueryBuilder queryBuilder) {
        SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[0]).setIndices(new String[]{this.getSearchAlias(this.index)}).setSize(0).setQuery(queryBuilder).setTrackTotalHits(true).execute().actionGet(this.suggestSettings.getSearchTimeout());
        return searchResponse.getHits().getTotalHits().value;
    }

    private String getSearchAlias(String index) {
        return index;
    }

    private String getUpdateAlias(String index) {
        return index + ".update";
    }

    private String createIndexName(String index) {
        return index + "." + ZonedDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
    }

    private String getDefaultMappings() throws IOException {
        StringBuilder mappingSource = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("suggest_indices/suggest/mappings-default.json")));){
            String line;
            while ((line = br.readLine()) != null) {
                mappingSource.append(line);
            }
        }
        return mappingSource.toString();
    }

    private String getDefaultIndexSettings() throws IOException {
        StringBuilder settingsSource = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("suggest_indices/suggest.json")));){
            String line;
            while ((line = br.readLine()) != null) {
                settingsSource.append(line);
            }
        }
        return settingsSource.toString();
    }

    private boolean isSuggestIndex(String indexName) {
        return indexName.startsWith(this.index);
    }
}

