/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.converter;

import com.ibm.icu.text.Transliterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codelibs.fess.suggest.converter.ReadingConverter;
import org.codelibs.fess.suggest.converter.ReadingConverterChain;
import org.codelibs.fess.suggest.settings.AnalyzerSettings;
import org.codelibs.fess.suggest.settings.SuggestSettings;
import org.opensearch.action.admin.indices.analyze.AnalyzeAction;
import org.opensearch.client.Client;
import org.opensearch.core.common.Strings;

public class AnalyzerConverter
implements ReadingConverter {
    protected final Client client;
    private final SuggestSettings settings;
    protected final AnalyzerSettings analyzerSettings;
    protected final Transliterator transliterator = Transliterator.getInstance((String)"Hiragana-Katakana");

    public AnalyzerConverter(Client client, SuggestSettings settings) {
        this.client = client;
        this.settings = settings;
        this.analyzerSettings = settings.analyzer();
    }

    @Override
    public void init() throws IOException {
    }

    @Override
    public List<String> convert(String text, String field, String ... langs) throws IOException {
        ReadingConverter converter;
        if (langs == null || langs.length == 0) {
            converter = new LangAnayzerConverter(null);
        } else {
            ReadingConverterChain chain = new ReadingConverterChain();
            for (String lang : langs) {
                chain.addConverter(new LangAnayzerConverter(lang));
            }
            converter = chain;
        }
        return converter.convert(text, field, new String[0]);
    }

    protected class LangAnayzerConverter
    implements ReadingConverter {
        protected final String lang;

        protected LangAnayzerConverter(String lang) {
            this.lang = lang;
        }

        @Override
        public void init() throws IOException {
        }

        @Override
        public List<String> convert(String text, String field, String ... dummy) throws IOException {
            AnalyzeAction.Response readingResponse = (AnalyzeAction.Response)AnalyzerConverter.this.client.admin().indices().prepareAnalyze(AnalyzerConverter.this.analyzerSettings.getAnalyzerSettingsIndexName(), text).setAnalyzer(AnalyzerConverter.this.analyzerSettings.getReadingAnalyzerName(field, this.lang)).execute().actionGet(AnalyzerConverter.this.settings.getIndicesTimeout());
            AnalyzeAction.Response termResponse = (AnalyzeAction.Response)AnalyzerConverter.this.client.admin().indices().prepareAnalyze(AnalyzerConverter.this.analyzerSettings.getAnalyzerSettingsIndexName(), text).setAnalyzer(AnalyzerConverter.this.analyzerSettings.getReadingTermAnalyzerName(field, this.lang)).execute().actionGet(AnalyzerConverter.this.settings.getIndicesTimeout());
            List readingTokenList = readingResponse.getTokens();
            List termTokenList = termResponse.getTokens();
            StringBuilder readingBuf = new StringBuilder(text.length());
            if (readingTokenList != null && termTokenList != null) {
                int offset = 0;
                for (int i = 0; i < readingTokenList.size(); ++i) {
                    String term = ((AnalyzeAction.AnalyzeToken)termTokenList.get(i)).getTerm();
                    String reading = ((AnalyzeAction.AnalyzeToken)readingTokenList.get(i)).getTerm();
                    if (Strings.isNullOrEmpty((String)reading)) {
                        reading = term;
                    }
                    reading = AnalyzerConverter.this.transliterator.transliterate(reading);
                    int pos = text.indexOf(term, offset);
                    if (pos > 0) {
                        String tmp = text.substring(offset, pos);
                        readingBuf.append(AnalyzerConverter.this.transliterator.transliterate(tmp));
                        offset = pos;
                    } else if (pos == -1) continue;
                    readingBuf.append(reading);
                    offset += term.length();
                }
            }
            ArrayList<String> list = new ArrayList<String>(1);
            if (readingBuf.length() > 0) {
                list.add(readingBuf.toString());
            }
            return list;
        }
    }
}

